<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html    = '';
$options = SitePageHelper::escapeHtmlArray($displayData['options']);

// Divider settings
if (!empty($options['divider_type'])) {
    // Divider style
    if (!empty($options['spacer_height'])) {
        $height_class = ' class="uk-flex uk-text-center uk-height-' . $options['spacer_height'] . '"';
    } else {
        $height_class = '';
    }
    // Build Divider HTML
    switch ($options['divider_type']) {
        case 'default':
            $html .= '<div' . $height_class . '>';
                $html .= '<div class="uk-margin-auto uk-margin-auto-vertical uk-width-4-5"><hr class="uk-margin"></div>';
            $html .= '</div>';

            break;
        case 'small':
            $html .= '<div' . $height_class . '>';
                $html .= '<div class="uk-margin-auto uk-margin-auto-vertical uk-width-4-5"><div class="uk-divider-small"></div></div>';
            $html .= '</div>';

            break;
        case 'icon':
            $html .= '<div' . $height_class . '>';
                $html .= '<div class="uk-margin-auto uk-margin-auto-vertical uk-width-4-5"><div class="uk-divider-icon"></div></div>';
            $html .= '</div>';

            break;
    }

    echo $html;
}
