<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');

use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html    = '';
$options = SitePageHelper::escapeHtmlArray($displayData['options']);

$title_show              = ($options['title_show'] ?? 1);
$title_position          = ($options['title_position'] ?? 0);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$close = ($options['close'] ?? 1);

// Build Alert HTML
if (!empty($options['title']) && $title_show === "1" && $title_position === "1") {
    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-alert-title');
}

if (!empty($options['content'])) {
    $html .= '<div class="' . $options['alert_type'] . '" uk-alert="">';
    if ($close) {
        $html .= '<a class="uk-alert-close" uk-close=""></a>';
    }
    if (!empty($options['title']) && $title_show === "1" && $title_position === "0") {
        $html .= '<' . $options['title_heading'] . ' class="ui-alert-title' . $title_class . '">';
            $html .= '<span>' . $options['title'] . '</span>';
        $html .= '</' . $options['title_heading'] . '>';
    }
        $html .= $options['content'];
    $html .= '</div>';
}

echo $html;
