<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html                    = '';
$options                 = SitePageHelper::escapeHtmlArray($displayData['options']);
$items                   = $displayData['items'];
$title_show              = ($options['title_show'] ?? 1);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

// Build List HTML
if (!empty($options['title']) && $title_show === "1") {
    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-accordion-title');
}

$html .= '<ul uk-accordion="">';
if (count($items)) {
    foreach ($items as $item_index => $item) {
        $item_options = SitePageHelper::escapeHtmlArray($item['options']);
        $random_id    = SitePageHelper::randomNumber();
        $item_class   = '-' . $random_id;
        $item_open    = ($item_options['item_open'] ?? 0);

        // Build Accordion HTML
        if ((!empty($item_options['item_title']) || !empty($item_options['item_title_icon'])) && (!empty($item_options['item_content']) || !empty($item_options['item_content_module']))) {
            if ($item_open === "1") {
                $item_class .= ' uk-open';
            }
            $html .= '<li class="accordion' . $item_class . '">';
                $html .= '<a class="uk-accordion-title" href="javascript:void(0)">';
            if (!empty($item_options['item_title_icon'])) {
                $html .= '<i class="' . $item_options['item_title_icon'] . '>"></i>';
            }
            if (!empty($item_options['item_title'])) {
                $html .= $item_options['item_title'];
            }
                $html .= '</a>';
            if (!empty($item_options['item_content'])) {
                $html .= '<div class="uk-accordion-content">';
                    $html .= $item_options['item_content'];
                $html .= '</div>';
                // Build Module Content
            } elseif (!empty($item_options['item_content_module'])) {
                if (Factory::getApplication()->isClient('site')) {
                    $moduleHTML = '';
                    $id         = $item_options['item_content_module'];
                    $modules    = ModuleHelper::getModuleList();
                    $module_title = '';

                    foreach ($modules as $module) {
                        if (!($module->id != $id)) {
                            if ($module->showtitle) {
                                $module_title = '<h5>' . $module->title . '</h5>';
                            }
                            $moduleHTML = ModuleHelper::renderModule($module);
                        }
                    }
                    // Build Module HTML
                    $html .= '<div class="uk-accordion-content">';
                        $html .= $module_title;
                        $html .= $moduleHTML;
                    // Build Module HTML Administrator
                } else {
                    $html .= '<div class="uk-accordion-content">';
                        $html .= '<div class="uk-alert-danger uk-padding-small" uk-alert="">';
                            $html .= '<a class="uk-alert-close" uk-close=""></a>';
                            $html .= '<h3 class="alert-heading">' . Text::_('COM_UITHEMEBUILDERLITE_MODULE_NO_PREVIEW') . '</h3>';
                            $html .= '<p>' . Text::_('COM_UITHEMEBUILDERLITE_MODULE_NO_PREVIEW_DESC') . '</p>';
                        $html .= '</div>';
                }
                $html .= '</div>';
            }
            $html .= '</li>';
        }
    }
}
$html .= '</ul>';

echo $html;
