<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

$published = $this->state->get('filter.published');
?>
<div class="modal hide fade" id="collapseModal">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&#215;</button>
        <h3><?php echo Text::_('COM_UITHEMEBUILDERLITE_BATCH_OPTIONS'); ?></h3>
    </div>
    <div class="modal-body modal-batch">
        <p><?php echo Text::_('COM_UITHEMEBUILDERLITE_BATCH_TIP'); ?></p>
        <div class="row">
            <div class="form-group col-md-6">
                <div class="controls">
                    <?php echo LayoutHelper::render('joomla.html.batch.language', []); ?>
                </div>
            </div>
            <div class="form-group col-md-6">
                <div class="controls">
                    <?php echo LayoutHelper::render('joomla.html.batch.access', []); ?>
                </div>
            </div>
        </div>
        <div class="row">
            <?php if ($published >= 0) : ?>
                <div class="form-group col-md-6">
                    <div class="controls">
                        <?php echo LayoutHelper::render('joomla.html.batch.item', ['extension' => 'com_uithemebuilderlite']); ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="form-group col-md-6">
                <div class="controls">
                    <?php echo LayoutHelper::render('joomla.html.batch.tag', []); ?>
                </div>
            </div>
            <div class="row">
                <div class="control-group">
                    <div class="controls">
                        <?php echo LayoutHelper::render('joomla.html.batch.user', ['noUser' => true]); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary" type="button"
                    onclick="document.getElementById('batch-category-id').value='';document.getElementById('batch-access').value='';document.getElementById('batch-language-id').value='';document.getElementById('batch-user-id').value='';document.getElementById('batch-tag-id').value=''"
                    data-dismiss="modal">
                <?php echo Text::_('JCANCEL'); ?>
            </button>
            <button class="btn btn-primary" type="submit" onclick="Joomla.submitbutton('page.batch');">
                <?php echo Text::_('JGLOBAL_BATCH_PROCESS'); ?>
            </button>
        </div>
    </div>
