<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use SW\Component\uiThemeBuilderLite\Administrator\Helper\PageHelper;

$canChange = true;
$assoc = Associations::isEnabled();
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDir = $this->escape($this->state->get('list.direction'));
$saveOrder = $listOrder === 'a.ordering';

if ($saveOrder && !empty($this->items)) {
    $saveOrderingUrl = 'index.php?option=com_uithemebuilderlite&task=pages.saveOrderAjax&tmpl=component&' . Session::getFormToken() . '=1';
    HTMLHelper::_('draggablelist.draggable');
}
?>
<form action="<?php echo Route::_('index.php?option=com_uithemebuilderlite'); ?>" method="post" name="adminForm"
      id="adminForm">
    <div class="row">
        <?php if (!empty($this->sidebar)) : ?>
            <div id="j-sidebar-container" class="col-md-2">
                <?php echo $this->sidebar; ?>
            </div>
        <?php endif; ?>
        <div class="<?php if (!empty($this->sidebar)) {
            echo 'col-md-10';
                    } else {
                        echo 'col-md-12';
                    } ?>">
            <div id="j-main-container" class="j-main-container">
                <?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
                <?php if (empty($this->items)) : ?>
                    <div class="alert alert-warning">
                        <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
                    </div>
                <?php else : ?>
                    <table class="table" id="pageList">
                        <thead>
                        <tr>
                            <th scope="col" style="width:1%" class="text-center d-none d-md-table-cell">
                                <?php echo HTMLHelper::_('searchtools.sort', '', 'a.ordering', $listDir, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
                            </th>
                            <td style="width:1%" class="text-center">
                                <?php echo HTMLHelper::_('grid.checkall'); ?>
                            </td>
                            <th scope="col" style="width:1%" class="text-center">
                                <?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'a.published', $listDir, $listOrder); ?>
                            </th>
                            <th scope="col" style="width:10%" class="text-center d-none d-md-table-cell">
                                <?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_TITLE', 'a.title', $listDir, $listOrder); ?>
                            </th>
                            <th scope="col" style="width:1%" class="text-center">
                                <?php echo HTMLHelper::_('searchtools.sort', 'JFEATURED', 'a.featured', $listDir, $listOrder); ?>
                            </th>
                            <th scope="col" style="width:1%" class="text-center d-none d-md-table-cell">
                                <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ACCESS', 'access_level', $listDir, $listOrder); ?>
                            </th>
                            <?php if ($assoc) : ?>
                                <th scope="col" style="width:1%">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JTOOLBAR_ASSOCIATIONS', 'association', $listDir, $listOrder); ?>
                                </th>
                            <?php endif; ?>
                            <?php if (Multilanguage::isEnabled()) : ?>
                                <th scope="col" style="width:1%" class="d-none d-md-table-cell">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_LANGUAGE', 'language_title', $listDir, $listOrder); ?>
                                </th>
                            <?php endif; ?>

                            <th scope="col" style="width:1%">
                                <?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_HITS', 'a.hits', $listDir, $listOrder); ?>
                            </th>

                            <th scope="col" style="width:1%">
                                <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDir, $listOrder); ?>
                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        $n = count($this->items);
                        foreach ($this->items as $i => $item) :
                            ?>
                            <tr class="row<?php echo $i % 2; ?>">
                                <td class="order text-center d-none d-md-table-cell">
                                    <?php
                                    $iconClass = '';
                                    if (!$canChange) {
                                        $iconClass = ' inactive';
                                    } elseif (!$saveOrder) {
                                        $iconClass = ' inactive tip-top hasTooltip" title="' . HTMLHelper::_('tooltipText', 'JORDERINGDISABLED');
                                    }
                                    ?>
                                    <span class="sortable-handler<?php echo $iconClass; ?>">
                                        <span class="icon-menu" aria-hidden="true"></span>
                                    </span>
                                    <?php if ($canChange && $saveOrder) : ?>
                                        <input type="text" style="display:none" name="order[]" size="5"
                                               value="<?php echo $item->ordering; ?>" class="width-20 text-area-order">
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
                                </td>
                                <td class="text-center">
                                    <?php
                                    echo HTMLHelper::_('jgrid.published', $item->published, $i, 'pages.', $canChange, 'cb', $item->publish_up, $item->publish_down);
                                    ?>
                                </td>
                                <th scope="row" class="has-context">
                                    <?php if ($item->checked_out) : ?>
                                        <?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'pages.', true); ?>
                                    <?php endif; ?>
                                    <div class="small">
                                        <?php $editIcon = '<span class="fa fa-pencil-square mr-2" aria-hidden="true"></span>'; ?>
                                        <?php echo $editIcon; ?>
                                        <a class="hasTooltip"
                                           href="<?php echo Route::_('index.php?option=com_uithemebuilderlite&task=page.edit&id=' . (int)$item->id); ?>"
                                           title="<?php echo Text::_('JACTION_EDIT'); ?> <?php echo $this->escape(addslashes($item->title)); ?>">
                                            <?php echo $this->escape($item->title); ?></a>

                                        <?php
                                        $itemid = PageHelper::getPageItemIdByLink('index.php?option=com_uithemebuilderlite&view=page&id=' . $item->id);
                                        $url = !empty($itemid) ? 'index.php?Itemid=' . $itemid : 'index.php?option=com_uithemebuilderlite&view=page&id=' . $item->id;
                                        if (Multilanguage::isEnabled() && $item->language !== '*') {
                                            $url .= '&lang=' . $item->language;
                                        }
                                        if (!empty($itemid)) { ?>
                                                <a class="hasTooltip uk-margin-small-left" target="_blank"
                                                     href="<?php echo Route::link('site', $url); ?>"
                                                     title="<?php echo Text::_('JGLOBAL_PREVIEW'); ?>"><span
                                                        class="icon-eye uk-text-primary"></span></a>
                                        <?php } ?>
                                    </div>


                                    <div class="small">
                                        <?php echo Text::_('JCATEGORY') . ': ' . $this->escape($item->category_title); ?>
                                    </div>
                                </th>
                                <td class="text-center">
                                    <?php echo HTMLHelper::_('uithemebuilderliteadministrator.featured', $item->featured, $i, $canChange); ?>
                                </td>
                                <td class="text-center small d-none d-md-table-cell">
                                    <?php echo $item->access_level; ?>
                                </td>

                                <?php if ($assoc) : ?>
                                    <td class="d-none d-md-table-cell">
                                        <?php if ($item->association) : ?>
                                            <?php
                                            echo HTMLHelper::_('uithemebuilderliteadministrator.association', $item->id);
                                            ?>
                                        <?php endif; ?>
                                    </td>
                                <?php endif; ?>
                                <?php if (Multilanguage::isEnabled()) : ?>
                                    <td class="text-center small d-none d-md-table-cell">
                                        <?php echo LayoutHelper::render('joomla.content.language', $item); ?>
                                    </td>
                                <?php endif; ?>

                                <td class="text-center small d-none d-md-table-cell">
                                    <?php echo (int)$item->hits; ?>
                                </td>

                                <td class="text-center small d-none d-md-table-cell">
                                    <?php echo (int)$item->id; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>

                    <?php echo $this->pagination->getListFooter(); ?>

                    <?php echo HTMLHelper::_(
                        'bootstrap.renderModal',
                        'collapseModal',
                        array(
                            'title' => Text::_('COM_UITHEMEBUILDERLITE_BATCH_OPTIONS'),
                            'footer' => $this->loadTemplate('batch_footer'),
                        ),
                        $this->loadTemplate('batch_body')
                    ); ?>

                <?php endif; ?>
                <input type="hidden" name="task" value="">
                <input type="hidden" name="boxchecked" value="0">
                <?php echo HTMLHelper::_('form.token'); ?>
            </div>
        </div>
    </div>
</form>
