<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021-2023 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Language\Text;
use SW\Component\uiThemeBuilderLite\Administrator\Helper\PageHelper;

$dir = JPATH_ADMINISTRATOR . '/components/com_uithemebuilderlite/forms/components/';
$files = glob("$dir*.xml");
$components_count = $files !== false ? count($files) : 0;

$dir_save_files = JPATH_ADMINISTRATOR . '/components/com_uithemebuilderlite/exports/sections/';
$save_files = glob("$dir_save_files*.save");
$save_files_count = $save_files !== false ? count($save_files) : 0;

$section_categories = [Text::_('COM_UITHEMEBUILDERLITE_ALL_COMPONENTS')];
// Get Save files...
foreach ($save_files as $file) {
    $fileContent = trim(file_get_contents($file));
    $fileDataArray = json_decode($fileContent, true, 512, JSON_THROW_ON_ERROR);
    if (array_key_exists('category', $fileDataArray)) {
        $section_categories[] = strtolower($fileDataArray['category']);
    }
}
$section_categories = array_map('trim', $section_categories);
ksort($section_categories);
/////////////////////////////////////////////////////////////////////////////////

$this->categories = array();
$this->categories[] = Text::_('COM_UITHEMEBUILDERLITE_ALL_COMPONENTS');
// Get components categories
foreach ($this->components as $i => $components) {
    $component_categories = explode(',', $components['category']);
    foreach ($component_categories as $component_category) {
        $this->categories[] = strtolower(trim(str_replace(',', ' ', $component_category)));
    }
}

$this->categories = array_map('trim', $this->categories);
$this->categories = array_unique($this->categories);
ksort($this->categories); ?>

<!-- Page option modal -->
<div id="ui-page-option-modal" class="uk-modal-container uk-flex-top"
     uk-modal="container: false; escClose: false; bgClose: false; modal: false">
    <div class="uk-modal-dialog uk-width-auto uk-margin-auto-vertical">
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><?php echo Text::_('COM_UITHEMEBUILDERLITE_PAGE_OPTIONS'); ?></h2>
        </div>
        <?php $fieldsets = $this->form->getFieldsets(); ?>
        <div class="uk-background-primary uk-light uk-padding-small">
            <ul class="uk-flex-center uk-subnav uk-margin-remove"
                uk-switcher="connect: .uk-switcher; animation: uk-animation-fade;">
                <li><a href="javascript:void(0)"><?php echo Text::_($fieldsets['page_settings']->label, true); ?></a>
                </li>
                <li><a href="javascript:void(0)"><?php echo Text::_($fieldsets['css_settings']->label, true); ?></a>
                </li>
                <li><a href="javascript:void(0)"><?php echo Text::_($fieldsets['seo_settings']->label, true); ?></a>
                </li>
                <li>
                    <a href="javascript:void(0)">
                        <?php echo Text::_($fieldsets['metadata_settings']->label, true); ?>
                    </a>
                </li>
                <li>
                    <a href="javascript:void(0)">
                        <?php echo Text::_($fieldsets['publishing_settings']->label, true); ?>
                    </a>
                </li>
                <li>
                    <a href="javascript:void(0)">
                        <?php echo Text::_($fieldsets['versioning_settings']->label, true); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="uk-modal-body" uk-overflow-auto>
            <div class="uk-height-medium page-option">

                <ul class="uk-switcher uk-margin">
                    <li>
                        <?php foreach ($this->form->getFieldset('page_settings') as $field_page_settings) { ?>
                            <div class="uk-form-horizontal uk-margin">
                                <?php echo $this->form->renderField($field_page_settings->fieldname); ?>
                            </div>
                        <?php } ?>
                    </li>
                    <li>
                        <?php foreach ($this->form->getFieldset('css_settings') as $field_css_settings) { ?>
                            <div class="uk-form-horizontal uk-margin">
                                <?php echo $this->form->renderField($field_css_settings->fieldname); ?>
                            </div>
                        <?php } ?>
                    </li>
                    <li>
                        <?php foreach ($this->form->getFieldset('seo_settings') as $field_seo_settings) { ?>
                            <div class="uk-form-horizontal uk-margin">
                                <?php echo $this->form->renderField($field_seo_settings->fieldname); ?>
                            </div>
                        <?php } ?>
                    </li>
                    <li>
                        <?php foreach ($this->form->getFieldset('metadata_settings') as $field_metadata_settings) { ?>
                            <div class="uk-form-horizontal uk-margin">
                                <?php echo $this->form->renderField($field_metadata_settings->fieldname); ?>
                            </div>
                        <?php } ?>
                    </li>
                    <li>
                        <?php
                        foreach ($this->form->getFieldset('publishing_settings') as $fields_publishing_settings) { ?>
                            <div class="uk-form-horizontal uk-margin">
                                <?php echo $this->form->renderField($fields_publishing_settings->fieldname); ?>
                            </div>
                            <?php
                        } ?>
                    </li>
                    <li>
                        <?php
                        foreach ($this->form->getFieldset('versioning_settings') as $field_versioning_settings) { ?>
                            <div class="uk-form-horizontal uk-margin">
                                <?php echo $this->form->renderField($field_versioning_settings->fieldname); ?>
                            </div>
                            <?php
                        } ?>
                    </li>
                </ul>

            </div>
            <div class="loader"><span class="uk-position-center" uk-spinner="ratio: 4.5"></span></div>
        </div>
        <div class="uk-modal-footer">
            <div class="uk-button-group">
                <a id="btn-apply-page-options" class="uk-button uk-button-primary"
                   href="javascript:void(0)"><?php echo Text::_('JOK'); ?></a>
                <a id="btn-cancel-page-options" class="uk-button uk-button-danger"
                   href="javascript:void(0)"><?php echo Text::_('JCANCEL'); ?></a>
            </div>
        </div>
    </div>
</div>

<!-- Section option modal -->
<div id="ui-modal-section-settings" class="uk-modal-container uk-flex-top"
     uk-modal="container: false; escClose: false; bgClose: false;">
    <div class="uk-modal-dialog uk-width-auto uk-margin-auto-vertical">
        <div class="uk-modal-header">
            <h2 class="uk-modal-title modal-title"><?php echo Text::_('COM_UITHEMEBUILDERLITE_ROW_SETTINGS'); ?></h2>
        </div>
        <div class="section-options"></div>
        <div class="uk-modal-footer">
            <div class="uk-button-group">
                <a href="javascript:void(0)" class="uk-button uk-button-primary"
                   id="btn-save-section"><?php echo Text::_('JOK'); ?></a>
                <button id="btn-cancel-section-settings"
                        class="uk-button uk-button-danger"><?php echo Text::_('JCANCEL'); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Page column modal -->
<div id="ui-modal-column-settings" class="uk-modal-container uk-flex-top"
     uk-modal="container: false; escClose: false; bgClose: false;">
    <div class="uk-modal-dialog uk-width-auto uk-margin-auto-vertical">
        <div class="uk-modal-header">
            <h2 class="uk-modal-title modal-title"><?php echo Text::_('COM_UITHEMEBUILDERLITE_COLUMN_SETTINGS'); ?></h2>
        </div>
        <div class="column-options"></div>
        <div class="uk-modal-footer">
            <div class="uk-button-group">
                <a href="javascript:void(0)" class="uk-button uk-button-primary"
                   id="save-column-settings"><?php echo Text::_('JOK'); ?></a>
                <button class="uk-button uk-button-danger"
                        id="cancel-column-settings"><?php echo Text::_('JCANCEL'); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Components modal -->
<div id="ui-modal-components-list" class="uk-modal-container uk-flex-top"
     uk-modal="container: false; escClose: false; bgClose: false;">
    <div class="uk-modal-dialog uk-width-auto uk-margin-auto-vertical">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title modal-title">
                <?php echo Text::_('COM_UITHEMEBUILDERLITE_COMPONENTS_LIST') . ' <sup>(' . $components_count . ')</sup>'; ?>
            </h2>
        </div>

        <div class="uk-modal-body" uk-overflow-auto>
            <div uk-filter="target: .components">
                <div class="uk-grid-small uk-grid-divider" uk-grid uk-height-match=".components-wrapper">
                    <div class="uk-width-1-4@l">
                        <div class="uk-height-medium">
                            <ul class="uk-nav uk-nav-default">
                                <?php
                                foreach ($this->categories as $key => $component_category) {
                                    $category_title_replace = PageHelper::componentCategoryToTitle($component_category);
                                    $category_title = ucwords(str_replace('_', ' ', $category_title_replace)); ?>
                                    <li <?php echo ($key == 0) ? 'class="uk-active" uk-filter-control' : 'class="" uk-filter-control="filter: .' . $component_category . '"'; ?>>
                                        <a href="javascript:void(0)"><?php echo $category_title; ?></a></li>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>
                    <div class="uk-width-expand@l">
                        <div class="components-wrapper"></div>
                    </div>
                </div>
            </div>
            <div class="loader"><span class="uk-position-center" uk-spinner="ratio: 4.5"></span></div>
        </div>
        <div class="uk-modal-footer">
            <div class="uk-inline">
                <span class="uk-form-icon" uk-icon="icon: search"></span>
                <a id="btn-component-filter-clear" class="uk-form-icon uk-form-icon-flip uk-hidden"
                   href="javascript:void(0)" uk-icon="icon: close; ratio: 0.8"></a>
                <input id="ui-component-filter" class="uk-input uk-form-width-large list-filter" type="text"
                       placeholder="<?php echo Text::_('COM_UITHEMEBUILDERLITE_SEARCH_COMPONENT'); ?>">
            </div>
        </div>
    </div>
</div>

<!-- Components edit modal -->
<div id="ui-modal-component" class="uk-modal-container uk-flex-top"
     uk-modal="container: false; escClose: false; bgClose: false;">
    <div class="uk-modal-dialog uk-width-auto uk-margin-auto-vertical">
        <div class="uk-modal-header">
            <h2 class="uk-modal-title modal-title"></h2>
        </div>

        <div class="component-preview">
            <div class="uk-panel uk-overflow-hidden"></div>
        </div>
        <div class="loader uk-height-large"><span class="uk-position-center" uk-spinner="ratio: 4.5"></span></div>

        <div class="uk-modal-footer">
            <div class="uk-button-group">
                <button id="options-toggle" class="uk-button uk-button-secondary">
                    <span uk-icon="icon: menu" uk-tooltip="title: <?php echo Text::_('COM_UITHEMEBUILDERLITE_HIDE_OPTIONS_TABS'); ?>; pos: right"></span>
                </button>
                <a href="javascript:void(0)" class="uk-button uk-button-primary"
                   id="btn-save-component"><?php echo Text::_('JOK'); ?></a>
                <button class="uk-button uk-button-danger"
                        id="btn-cancel-component-settings"><?php echo Text::_('JCANCEL'); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Image select/upload modal -->
<div id="ui-modal-upload-image" class="uk-modal-full"
     uk-modal="container: false; escClose: false; bgClose: false; stack: true">
    <div class="uk-modal-dialog">
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><?php echo Text::_('JLIB_FORM_CHANGE_IMAGE'); ?></h2>
        </div>
        <div class="uk-modal-body uk-padding-remove" uk-height-viewport="offset-top: true;"></div>
        <div class="uk-modal-footer">
            <div class="uk-button-group">
                <button class="uk-button uk-button-primary button-select"
                        id="btn-add-image"><?php echo Text::_('JSELECT'); ?></button>
                <button class="uk-button uk-button-danger"
                        id="btn-cancel-image"><?php echo Text::_('JCANCEL'); ?></button>
            </div>
        </div>
        <div class="loader"><span class="uk-position-center" uk-spinner="ratio: 4.5"></span></div>
    </div>
</div>

<!-- Pro modal -->
<div id="ui-modal-pro" class="uk-flex-top" uk-modal="container: false; escClose: false; bgClose: false; stack: true">
    <div class="uk-modal-dialog uk-margin-auto-vertical">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title modal-title">Get Pro</h2>
        </div>
        <div class="uk-modal-body uk-height-medium uk-flex uk-flex-middle uk-flex-center">
            <div>
                <p><?php echo Text::_("COM_UITHEMEBUILDERLITE_PRO"); ?></p>
                <div class="uk-padding-small uk-text-center">
                    <a class="uk-button uk-button-large uk-button-primary" href="https://www.ui-themebuilder.com/pricing.html" target="_blank"><i class="uk-margin-small-right fas fa-dollar-sign"></i>Buy Pro</a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Library modal -->
<div id="ui-modal-library" class="uk-modal-container uk-flex-top" uk-modal="container: false; escClose: false; bgClose: false;">
    <div class="uk-modal-dialog uk-width-auto uk-margin-auto-vertical">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title modal-title"><?php echo Text::_('COM_UITHEMEBUILDERLITE_LIBRARY_LIST'); ?></h2>
        </div>

        <div class="uk-modal-body uk-padding-remove" uk-overflow-auto>
            <div class="uk-cover-container uk-height-large uk-background-top-center">
                <img src="../media/com_uithemebuilderlite/images/library.png" uk-img uk-cover alt="library">
                <div class="uk-overlay-primary uk-position-cover"></div>
                <div class="uk-overlay uk-position-center uk-light">
                    <p><?php echo Text::_('COM_UITHEMEBUILDERLITE_PRO'); ?></p>
                </div>
            </div>
            <div class="loader"><span class="uk-position-center" uk-spinner="ratio: 4.5"></span></div>
        </div>
        <div class="uk-modal-footer">
            <div class="uk-inline">
                <span class="uk-form-icon" uk-icon="icon: search"></span>
                <input class="uk-input uk-form-width-large" type="text" placeholder="<?php echo Text::_('COM_UITHEMEBUILDERLITE_SEARCH_SECTIONS'); ?>" disabled="">
            </div>
        </div>
    </div>
</div>

<!-- Components clone -->
<div id="ui-components" class="uk-hidden" hidden>
    <ul class="components uk-child-width-1-1@s uk-child-width-1-3@m uk-child-width-1-4@l uk-grid-collapse uk-grid-match"
        uk-grid="">
        <?php
        foreach ($this->components as $component) {
            $icons = $component['type'];
            $typeclass = str_replace('_', '-', $component['type']) . '-component';
            $desc = PageHelper::componentDesc($component['type']);

            $title = PageHelper::componentTypeToTitle($component['type']);
            $rn = PageHelper::randomNumber(); ?>

            <li class="<?php echo trim(str_replace(',', ' ', $component['category'])); ?> uk-padding-small uk-text-center">

                <a href="javascript:void(0)" id="<?php echo $typeclass; ?>"
                   class="uk-link-reset uk-display-block uk-card uk-card-body uk-card-default uk-link-toggle uk-card-small uk-card-hover"
                   data-component="c" hidden uk-tooltip="title: <?php echo $desc; ?>;">
                    <div class="uk-card-media-top uk-margin-small-top">
                        <img class="uk-preserve"
                             src="<?php echo '../media/com_uithemebuilderlite/images/icons/icons.min.svg#' . $icons; ?>"
                             width="70" height="70" uk-svg>
                    </div>
                    <div class="uk-card-title">
                        <span id="<?php echo $component['type']; ?>"
                              class="uk-link-heading uk-text-small component-title"><?php echo $title; ?></span>
                    </div>
                </a>

                <div id="ui-component" class="ui-<?php echo str_replace('_', '-', $component['type']); ?>" hidden>
                    <div class="ui-component-container uk-position-relative">
                        <div class="component-tools uk-position-absolute uk-position-bottom-center uk-light">
                            <div uk-grid="" class="uk-grid-small uk-flex-middle">
                                <div class="uk-width-auto">
                                    <div uk-grid="" class="uk-grid-small uk-flex-middle">
                                        <div class="uk-width-auto">
                                            <ul class="uk-iconnav ui-background-secondary">
                                                <li title="" tabindex="0"
                                                    uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_TOGGLE_COMPONENT_OPTIONS'); ?>">
                                                    <a href="javascript:void(0)"
                                                       class="btn-component-options-toggle uk-text-emphasis uk-icon-button ui-icon-button"
                                                       uk-toggle="target: #component-options-toggle-1<?php echo $rn; ?>">
                                                        <i class="uk-icon" uk-icon="icon: more-vertical; ratio: .8"></i>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <div id="component-options-toggle-1<?php echo $rn; ?>"
                                             class="component-options-toggle uk-width-auto uk-flex-middle" hidden="">
                                            <div uk-grid="">
                                                <div class="uk-width-expand">
                                                    <ul class="uk-iconnav">
                                                        <li><a class="btn-edit-component uk-icon-button ui-icon-button"
                                                               href="javascript:void(0)" onclick="return false;"
                                                               uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_EDIT_ELEMENT'); ?>"><i
                                                                    uk-icon="icon: pencil; ratio: .8"></i></a></li>
                                                        <li>
                                                            <a class="btn-duplicate-component uk-icon-button ui-icon-button"
                                                               href="javascript:void(0)"
                                                               uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_DUPLICATE_ELEMENT'); ?>"><i
                                                                    uk-icon="icon: copy; ratio: .8"></i></a></li>
                                                        <li>
                                                            <a class="btn-delete-component uk-icon-button ui-icon-button"
                                                               href="javascript:void(0)" onclick="return false;"
                                                               uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_REMOVE_ELEMENT'); ?>"><i
                                                                    uk-icon="icon: trash; ratio: .8"></i></a></li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="uk-width-expand">
                                    <div class="uk-flex uk-flex-right">
                                    <span
                                        class="uk-text-muted uk-drag component-title uk-text-small uk-text-truncate move-component uk-overlay uk-overlay-primary uk-padding-small uk-padding-remove-vertical ">
                                        <?php echo ucwords(str_replace('_', ' ', $component['type'])); ?>
                                    </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="ui-component-content"></div>

                        <div class="component-options uk-hidden"></div>
                        <input class="json-component" type="hidden"
                               value="<?php echo $this->escape(json_encode($component, JSON_THROW_ON_ERROR)); ?>">
                    </div>
                </div>

            </li>
        <?php } ?>
    </ul>
</div>
