<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2023 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use SW\Component\uiThemeBuilderLite\Administrator\Helper\PageHelper;

$app   = Factory::getApplication();
$input = $app->input;

$assoc = Associations::isEnabled();

$this->ignore_fieldsets = array ('item_associations');
$this->useCoreUI        = true;

// In case of modal
$isModal = $input->get('layout') === 'modal';
$layout  = $isModal ? 'modal' : 'edit';
$tmpl    = $isModal || $input->get('tmpl', '') === 'component' ? '&tmpl=component' : '';


$this->section_config = PageHelper::getSectionConfig();
$this->column_config  = PageHelper::getColumnConfig();
$this->components     = PageHelper::getComponents();

$config_params               = ComponentHelper::getParams('com_uithemebuilderlite');
$save_history_uithemebuilder = $config_params->get('save_history');
$save_history                = $app->get('save_history', true);

if ($save_history && $save_history_uithemebuilder === "1") {
    $wa = $this->document->getWebAssetManager();
    $wa->getRegistry()->addExtensionRegistryFile('com_contenthistory');
    $wa->useScript('keepalive')
        ->useScript('form.validate')
        ->useScript('com_contenthistory.admin-history-versions');
} ?>

<script type="text/javascript">
    function go_full_screen() {
        const {documentElement: e} = document
        e.requestFullscreen ? e.requestFullscreen() : e.msRequestFullscreen ? e.msRequestFullscreen() : e.mozRequestFullScreen ? e.mozRequestFullScreen() : e.webkitRequestFullscreen && e.webkitRequestFullscreen()
    }

    window.onload = function () {
        function e(e) {
            function n() {
                (window.clearInterval(l), e.call(this)) && void 0 !== document.getElementsByTagName("body")[0]
            }

            const l = window.setInterval(n, 2e3)
        }

        function n(e, n) {
            document.getElementById(e).style.visibility = n ? "visible" : "hidden", document.getElementById(e).style.display = n ? "block" : "none"
        }

        e(function () {
            n("uithemebuilder-admin", !0), n("loading", !1)
        })
    }
</script>
<!-- Loading spinner -->
<div id="loading"><span class="uk-position-center" uk-spinner="ratio: 4.5"></span></div>

<div id="uithemebuilder-admin" class="uithemebuilder-admin">
    <form action="#" method="post" name="adminForm" id="adminForm" class="form-validate">

        <!-- Navbar -->
        <div
            uk-sticky="animation: uk-animation-slide-top; sel-target: .navbar-admin; cls-active: uk-navbar-sticky; top: 600;">
            <nav id="navbar-container-admin" class="uk-navbar-container navbar-admin">
                <div class="uk-container">
                    <div uk-navbar>
                        <div class="uk-navbar-left">

                            <ul class="uk-navbar-nav">
                                <li>
                                    <a href="javascript:void(0)"><span uk-icon="icon: ui-save; ratio: 1.3"></span></a>
                                    <div class="uk-navbar-dropdown">
                                        <ul class="uk-nav uk-navbar-dropdown-nav">
                                            <li>
                                                <a id="btn-save-page" href="javascript:void(0)"
                                                   onclick="Joomla.submitbutton('page.apply');"><?php echo Text::_('JTOOLBAR_APPLY'); ?></a>
                                            </li>
                                            <li>
                                                <a id="btn-save-close" href="javascript:void(0)"
                                                   onclick="Joomla.submitbutton('page.save');"><?php echo Text::_('JTOOLBAR_SAVE'); ?></a>
                                            </li>
                                            <li>
                                                <a id="btn-save-new" href="javascript:void(0)"
                                                   onclick="Joomla.submitbutton('page.save2new');"><?php echo Text::_('JTOOLBAR_SAVE_AND_NEW'); ?></a>
                                            </li>
                                            <!-- <li>
                                                <a id="btn-save-copy" href="javascript:void(0)"
                                                   onclick="Joomla.submitbutton('page.save2copy');" task="page.save2copy"><?php echo Text::_('JTOOLBAR_SAVE_AS_COPY'); ?></a>
                                            </li> -->
                                            <li class="uk-nav-divider"></li>
                                            <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_SAVE_ALL_SECTIONS_DESC'); ?>">
                                                <a id="btn-save-all-sections"
                                                   href="javascript:void(0)"><?php echo Text::_('COM_UITHEMEBUILDERLITE_SAVE_ALL_SECTIONS'); ?></a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                <?php
                                $disabled = !empty($this->item->id) ? '' : ' class="uk-disabled uk-link-reset"'; ?>
                                <li>
                                    <a id="ui-theme-export"<?php echo $disabled; ?> href="javascript:void(0)"
                                       uk-tooltip="title: <?php echo Text::_('JTOOLBAR_EXPORT'); ?>; pos: bottom"><span
                                            class="uk-icon" uk-icon="icon: download; ratio: 2.0"></span></a>
                                </li>
                                <li>
                                    <a class="ui-responsive-reset" href="javascript:void(0)"><span
                                            uk-icon="icon: list; ratio: 1.3"
                                            uk-tooltip="title: <?php echo Text::_('COM_UITHEMEBUILDERLITE_RESET_RESPONSIVE_SETTINGS'); ?>; pos: bottom"></span></a>
                                    <div class="uk-navbar-dropdown">
                                        <ul class="uk-nav uk-navbar-dropdown-nav">
                                            <li class="ui-tv">
                                                <a href="javascript:void(0)"><span
                                                        uk-icon="icon: tv; ratio: 1.3"></span> TV</a>
                                            </li>
                                            <li class="ui-desktop">
                                                <a href="javascript:void(0)"><span
                                                        uk-icon="icon: desktop; ratio: 1.3"></span> Desktop</a>
                                            </li>
                                            <!-- <li class="ui-laptop">
                                                <a href="javascript:void(0)"><span uk-icon="icon: laptop; ratio: 1.3"></span></a>
                                            </li> -->
                                            <li class="ui-tablet">
                                                <a href="javascript:void(0)"><span
                                                        uk-icon="icon: tablet-landscape; ratio: 1.3"></span> Tablet</a>
                                            </li>
                                            <li class="ui-phone">
                                                <a href="javascript:void(0)"><span
                                                        uk-icon="icon: phone-landscape; ratio: 1.3"></span>
                                                    Phone</a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                            </ul>

                        </div>
                        <div class="uk-navbar-center">

                            <a class="uk-navbar-item uk-logo"
                               href="index.php?option=com_uithemebuilderlite&view=pages"><span><?php echo LayoutHelper::render('logo'); ?><sup
                                        class="uk-margin-small-left uk-text-small"><b>Lite</b> v.<?php echo PageHelper::getVersion(); ?></sup></span></a>

                        </div>
                        <div class="uk-navbar-right">

                            <ul class="uk-navbar-nav">

                                <?php if (!empty($this->item->id)) {
                                    $itemid = PageHelper::getPageItemIdByLink('index.php?option=com_uithemebuilderlite&view=page&id=' . $this->item->id);
                                    $url    = !empty($itemid) ? 'index.php?Itemid=' . $itemid : 'index.php?option=com_uithemebuilderlite&view=page&id=' . $this->item->id;
                                    if (Multilanguage::isEnabled() && $this->item->language !== '*') {
                                        $url .= '&lang=' . $this->item->language;
                                    }

                                    if (!empty($itemid)) { ?>
                                        <li>
                                            <a id="btn-page-preview" href="<?php echo Route::link('site', $url); ?>"
                                               target="_blank"
                                               uk-tooltip="title:<?php echo Text::_('JGLOBAL_PREVIEW'); ?>; pos: bottom">
                                                <span class="far fa-eye"></span></a>
                                        </li>
                                    <?php } ?>
                                <?php } ?>
                                <li>
                                    <a href="javascript:void(0)"><span
                                            uk-icon="icon: thumbnails; ratio: 1.4"></span></a>
                                    <div class="uk-navbar-dropdown">
                                        <ul class="uk-nav uk-navbar-dropdown-nav">
                                            <li>
                                                <a class="btn-add-section"
                                                   href="javascript:void(0)"><?php echo Text::_('COM_UITHEMEBUILDERLITE_ADD_ROW'); ?></a>
                                            </li>
                                            <li>
                                                <a class="btn-add-section-from-library"
                                                   href="javascript:void(0)"><?php echo Text::_('COM_UITHEMEBUILDERLITE_ADD_LIBRARY'); ?></a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                <li>
                                    <a href="javascript:void(0)" id="btn-page-options"
                                       uk-tooltip="title:<?php echo Text::_('COM_UITHEMEBUILDERLITE_PAGE_OPTIONS'); ?>; pos: bottom"><span
                                            uk-icon="icon: settings; ratio: 1.3"></span></a>
                                </li>
                                <li>
                                    <a href="javascript:void(0)" onclick="go_full_screen();"
                                       uk-tooltip="title: Fullscreen; pos: bottom"><span
                                            uk-icon="icon: ui-fullscreen; ratio: 1.3"></span></a>
                                </li>
                            </ul>

                        </div>
                    </div>
                </div>
            </nav>
        </div>

        <!-- Toolbar -->
        <div class="ui-toolbar uk-background-primary uk-light uk-padding-small">
            <div
                class="uk-panel uk-form-horizontal"><?php echo LayoutHelper::render('joomla.edit.title_alias', $this); ?></div>
        </div>

        <!-- Page Content -->
        <?php if ($this->item->content) { ?>
            <div class="ui-themebuilder-wrapper ui-section-content uk-section uk-section-default uk-padding-remove-vertical"
                uk-sortable="handle: .uk-drag.move-section">

                <?php
                $itemContent = trim($this->item->content);

                foreach (json_decode($itemContent, false, 512, JSON_THROW_ON_ERROR) as $key => $section) {
                    $json_section = PageHelper::toArray($section);
                    unset($json_section['columns']);

                    $doc  = $app->getDocument();
                    $wa   = $this->document->getWebAssetManager();
                    $html = '';
                    // $html_data   = '';

                    $section                      = PageHelper::toArray($section);
                    $section_options              = PageHelper::escapeHtmlArray($section['options']);
                    $rdNr                         = $key . PageHelper::randomNumber();
                    $title_show                   = ($section_options['title_show'] ?? 1);
                    $titleAndSubtitleClasses      = PageHelper::getTitleAndSubtitleClasses($section_options);
                    $title_class                  = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];
                    $subtitle_class               = ($titleAndSubtitleClasses['subtitle'] === '') ? '' : ' ' . $titleAndSubtitleClasses['subtitle'];
                    $titleMargin                  = '';
                    $subtitleMargin               = '';
                    $heading_alignment            = '';
                    $position_relative            = '';
                    $section_svg_divider_z_index  = '';
                    $section_css                  = '';
                    $section_divider_top          = '';
                    $section_divider_top_color    = '';
                    $section_divider_bottom       = '';
                    $section_divider_bottom_color = '';
                    $buildStyle                   = '';
                    $container_buildStyle         = '';
                    $section_full_width           = ($section_options['section_full_width'] ?? 1);
                    $section_classes              = '';
                    $section_mask_classes         = '';
                    $grid_match                   = ($section_options['grid_match'] ?? 1);
                    $grid_match_row               = (isset($section_options['grid_match_row']) && $section_options['grid_match_row'] === "1" && $section_options['grid_match'] === "1" ? ' row: false' : '');
                    $grid_match_target            = (isset($section_options['grid_match_target']) && $section_options['grid_match'] === "1" && !empty($section_options['grid_match_target']) ? 'target: ' . $section_options['grid_match_target'] . ';' : '');
                    $grid_gutter_class            = '';
                    $container_classes            = '';
                    $section_height_viewport      = '';
                    $parallax_x                   = '';
                    $parallax_y                   = '';
                    $section_parallax             = '';
                    $background_image_srcset      = ($section_options['background_image_srcset'] ?? 0);
                    $srcsets                      = [];
                    $srcset                       = '';
                    $section_style                = [];
                    $container_style              = [];

                    $inline_css_section = '';

                    $custom_background = ($section_options['custom_background'] ?? 0);

                    $shape_position      = ($section_options['shape_position'] ?? 'left');
                    $section_shape_class = '';
                    $shape_margin_top    = ((isset($section_options['shape_margin_top']) && !empty($section_options['shape_margin_top'])) ? $section_options['shape_margin_top'] . 'px' : 0);
                    $shape_margin_right  = ((isset($section_options['shape_margin_right']) && !empty($section_options['shape_margin_right'])) ? $section_options['shape_margin_right'] . 'px' : 0);
                    $shape_margin_bottom = ((isset($section_options['shape_margin_bottom']) && !empty($section_options['shape_margin_bottom'])) ? $section_options['shape_margin_bottom'] . 'px' : 0);
                    $shape_margin_left   = ((isset($section_options['shape_margin_left']) && !empty($section_options['shape_margin_left'])) ? $section_options['shape_margin_left'] . 'px' : 0);

                    $shape_position_zindex = ($section_options['shape_position_zindex'] ?? 0);
                    $shape_border          = ((isset($section_options['shape_border']) && !empty($section_options['shape_border'])) ? $section_options['shape_border'] . 'px' : '');
                    $shape_transform       = ($section_options['shape_transform'] ?? 'unset');
                    $shape_shadow          = ((isset($section_options['shape_shadow']) && !empty($section_options['shape_shadow'])) ? ' ' . $section_options['shape_shadow'] : '');

                    $shape_background_image_repeat     = ($section_options['shape_background_image_repeat'] ?? 0);
                    $shape_background_image_attachment = ($section_options['shape_background_image_attachment'] ?? "");
                    $shape_background_image_position   = ((isset($section_options['shape_background_image_position']) && !empty($section_options['shape_background_image_position']) && !empty($section_options['shape_background_image'])) ? ' ' . $section_options['shape_background_image_position'] : '');

                    $section_svg_background_image_responsive = ($section_options['section_svg_background_image_responsive'] ?? '');

                    $section_key_show = ($section_options['section_key'] ?? 0);

                    $currentDate              = Factory::getDate()->format('Y-m-d H:i:s');
                    $get_publish_down_section = ($section_options['publish_down'] ?? null);
                    $get_publish_up_section   = ($section_options['publish_up'] ?? null);

                    $publish_down      = $get_publish_down_section == null ? null : $section_options['publish_down'];
                    $isExpired         = !is_null($publish_down) && strtotime($publish_down) < strtotime($currentDate);
                    $isNotPublishedYet = strtotime($get_publish_up_section) > strtotime($currentDate);
                    $isUnpublished     = $isNotPublishedYet || $isExpired;

                    $section_show = true;

                    if ($isExpired) {
                        $section_show = false;
                    } elseif ($isUnpublished) {
                        $section_show = false;
                    }


                    // Section visibility and check date
                    if ($section['admin_visibility'] === '0') {
                        $section_admin_visibility = ' uk-text-danger';
                    } else {
                        $section_admin_visibility = '';
                    }

                    // if ($section['admin_visibility'] == '1' && $section_show)
                    // {

                    if (!empty($section_options['class'])) {
                        $section_classes .= ' ' . $section_options['class'];
                    }

                    // Alignment section content
                    if ($section_options['section_align_content'] === "1" && $section_options['heading_alignment'] === 'uk-text-left' && (!empty($section_options['title']) || !empty($section_options['subtitle']))) {
                        $section_classes .= ' uk-flex uk-flex-middle';
                    } elseif ($section_options['section_align_content'] === "1" && $section_options['heading_alignment'] === 'uk-text-right' && (!empty($section_options['title']) || !empty($section_options['subtitle']))) {
                        $section_classes .= ' uk-flex uk-flex-middle uk-flex-right';
                    } elseif ($section_options['section_align_content'] === "1" && $section_options['heading_alignment'] === 'uk-text-center' && (!empty($section_options['title']) || !empty($section_options['subtitle']))) {
                        $section_classes .= ' uk-flex uk-flex-middle uk-flex-center';
                    } elseif ($section_options['section_align_content'] === "1" && $section_full_width === "1" && !empty($section_options['container_width']) && $section_options['section_load_components'] === "1") {
                        $section_classes   .= ' uk-flex uk-flex-middle';
                        $container_classes .= ' uk-width-3-4@xl uk-width-2-3@l';
                    } elseif ($section_options['section_align_content'] === "1") {
                        $section_classes .= ' uk-flex uk-flex-middle';
                    }
                    // END Alignment section content

                    if (!empty($section_options['visibility'])) {
                        $section_classes .= ' ' . $section_options['visibility'];
                    }
                    if (!empty($section_options['hidden'])) {
                        $section_classes .= ' ' . $section_options['hidden'];
                    }
                    if (!empty($section_options['section_padding'])) {
                        $section_classes .= ' ' . $section_options['section_padding'];
                    }
                    if (!empty($section_options['section_margin'])) {
                        $section_classes .= ' ' . $section_options['section_margin'];
                    }

                    // Section Dividers
                    if ((!empty($section_options['section_divider_bottom']) || !empty($section_options['section_divider_top'])) && $section_options['section_divider_z_index'] === "1") {
                        $section_svg_divider_z_index = ' uk-position-z-index';
                    }
                    $divider_paths = PageHelper::getSectionDividers($section_options);

                    if (!empty($section_options['section_divider_top'])) {
                        $svg_paths_top   = $divider_paths['svg_paths_top'];
                        $section_classes .= ' ui-separator-top-' . $rdNr;

                        if (!empty($section_options['section_divider_top_color'])) {
                            $shape_paths_color_t = 'fill: ' . $section_options['section_divider_top_color'] . ';';
                        } elseif (($section_options['section_divider_top_gradient'] === "1") && (!empty($section_options['section_divider_top_color_1'])) && (!empty($section_options['section_divider_top_color_2']))) {
                            $shape_paths_color_t = 'fill: url(#ui-gradient-' . $rdNr . ');';
                        } else {
                            $shape_paths_color_t = '';
                        }

                        if ($section_options['section_divider_top_dropshadow'] === "1") {
                            $section_divider_top .= '<svg class="ui-separator ui-separator-top-' . $rdNr . $section_svg_divider_z_index . '" viewBox="0 0 200 30" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="overflow: visible">';
                        } else {
                            $section_divider_top .= '<svg class="ui-separator ui-separator-top-' . $rdNr . $section_svg_divider_z_index . '" viewBox="0 0 200 30" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">';
                        }
                        // SVG Filter´s Gradient / DropShadow (Top)
                        if (($section_options['section_divider_top_gradient'] === "1") || ($section_options['section_divider_top_dropshadow'] === "1")) {
                            $section_divider_top .= '<defs>';
                            // Gradient
                            if (($section_options['section_divider_top_gradient'] === "1") && (!empty($section_options['section_divider_top_color_1'])) && (!empty($section_options['section_divider_top_color_2']))) {
                                $section_divider_top .= '<linearGradient id="ui-gradient-' . $rdNr . '" x1="' . $section_options['gradient_x1_position'] . '%" y1="' . $section_options['gradient_y1_position'] . '%" x2="' . $section_options['gradient_x2_position'] . '%" y2="' . $section_options['gradient_y2_position'] . '%" color-interpolation-filters="sRGB">';
                                $section_divider_top .= '<stop offset="' . $section_options['section_divider_top_color_1_position'] . '%" style="stop-color:' . $section_options['section_divider_top_color_1'] . ';stop-opacity:1" />';
                                $section_divider_top .= '<stop offset="' . $section_options['section_divider_top_color_2_position'] . '%" style="stop-color:' . $section_options['section_divider_top_color_2'] . ';stop-opacity:1" />';
                                $section_divider_top .= '</linearGradient>';
                            }
                            // DropShadow
                            if ($section_options['section_divider_top_dropshadow'] === "1") {
                                $section_divider_top .= '<filter id="dropshadowfiltertop-section-' . $rdNr . '" filterUnits="userSpaceOnUse" x="0" y="0" width="100%" height="120%" color-interpolation-filters="sRGB">';
                                $section_divider_top .= '<feGaussianBlur in="SourceAlpha" result="blur" stdDeviation="' . $section_options['section_dropShadow_blur_top'] . '"></feGaussianBlur>';
                                $section_divider_top .= '<feFlood flood-color="' . $section_options['section_filter_dropShadow_color_top'] . '" result="color" ></feFlood>';
                                $section_divider_top .= '<feComposite in="color" in2="blur" operator="in" result="ShadowBlur"></feComposite>';
                                $section_divider_top .= '<feOffset in="ShadowBlur" result="dropShadow" dx="0" dy="' . $section_options['section_dropShadow_blur_y_offset_top'] . '"></feOffset>';
                                $section_divider_top .= '<feMerge>';
                                $section_divider_top .= '<feMergeNode in="dropShadow"></feMergeNode>';
                                $section_divider_top .= '<feMergeNode in="SourceGraphic"></feMergeNode>';
                                $section_divider_top .= '</feMerge>';
                                $section_divider_top .= '</filter>';
                            }
                            $section_divider_top .= '</defs>';
                        }
                        // END SVG Filter´s
                        if ($section_options['section_divider_top_dropshadow'] === "1") {
                            $section_divider_top .= '<g filter="url(#dropshadowfiltertop-section-' . $rdNr . ')">';
                            $section_divider_top .= $svg_paths_top;
                            $section_divider_top .= '</g>';
                        } else {
                            $section_divider_top .= $svg_paths_top;
                        }

                        $section_divider_top .= '</svg>';

                        // Inline CSS Top Divider
                        if (!empty($section_options['section_divider_top_height'])) {
                            $section_css .= '.ui-separator.ui-separator-top-' . $rdNr . '{height:' . $section_options['section_divider_top_height'] . 'px}';
                        }
                        $section_css .= '.ui-separator.ui-separator-top-' . $rdNr . ' path{' . $shape_paths_color_t . ' stroke-linecap:round}';
                    }

                    if (!empty($section_options['section_divider_bottom'])) {
                        $svg_paths_bottom = $divider_paths['svg_paths_bottom'];
                        $section_classes  .= ' ui-separator-bottom-' . $rdNr;

                        if (!empty($section_options['section_divider_bottom_color'])) {
                            $shape_paths_color_b = 'fill:' . $section_options['section_divider_bottom_color'] . ';';
                        } elseif (($section_options['section_divider_bottom_gradient'] === "1") && (!empty($section_options['section_divider_bottom_color_1'])) && (!empty($section_options['section_divider_bottom_color_2']))) {
                            $shape_paths_color_b = 'fill:url(#ui-gradient-bottom-' . $rdNr . ');';
                        } else {
                            $shape_paths_color_b = '';
                        }

                        if ($section_options['section_divider_bottom_dropshadow'] === "1") {
                            $section_divider_bottom .= '<svg class="ui-separator ui-separator-bottom-' . $rdNr . $section_svg_divider_z_index . '" viewBox="0 0 200 30" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="overflow: visible">';
                        } else {
                            $section_divider_bottom .= '<svg class="ui-separator ui-separator-bottom-' . $rdNr . $section_svg_divider_z_index . '" viewBox="0 0 200 30" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">';
                        }
                        // SVG Filter´s Gradient / DropShadow (Bottom)
                        if (($section_options['section_divider_bottom_gradient'] === "1") || ($section_options['section_divider_bottom_dropshadow'] === "1")) {
                            $section_divider_bottom .= '<defs>';
                            // Gradient
                            if (($section_options['section_divider_bottom_gradient'] === "1") && (!empty($section_options['section_divider_bottom_color_1'])) && (!empty($section_options['section_divider_bottom_color_2']))) {
                                $section_divider_bottom .= '<linearGradient id="ui-gradient-bottom-' . $rdNr . '" x1="' . $section_options['gradient_x1_position_bottom'] . '%" y1="' . $section_options['gradient_y1_position_bottom'] . '%" x2="' . $section_options['gradient_x2_position_bottom'] . '%" y2="' . $section_options['gradient_y2_position_bottom'] . '%">';
                                $section_divider_bottom .= '<stop offset="' . $section_options['section_divider_bottom_color_1_position'] . '%" style="stop-color:' . $section_options['section_divider_bottom_color_1'] . ';stop-opacity:1" />';
                                $section_divider_bottom .= '<stop offset="' . $section_options['section_divider_bottom_color_2_position'] . '%" style="stop-color:' . $section_options['section_divider_bottom_color_2'] . ';stop-opacity:1" />';
                                $section_divider_bottom .= '</linearGradient>';
                            }
                            // DropShadow
                            if ($section_options['section_divider_bottom_dropshadow'] === "1") {
                                $section_divider_bottom .= '<filter id="dropshadowfilter-bottom-section-' . $rdNr . '" filterUnits="userSpaceOnUse" x="0" y="-20%" width="100%" height="120%" color-interpolation-filters="sRGB">';
                                $section_divider_bottom .= '<feGaussianBlur in="SourceAlpha" result="blur" stdDeviation="' . $section_options['section_dropShadow_blur_bottom'] . '"></feGaussianBlur>';
                                $section_divider_bottom .= '<feFlood flood-color="' . $section_options['section_filter_dropShadow_color_bottom'] . '" result="color" ></feFlood>';
                                $section_divider_bottom .= '<feComposite in="color" in2="blur" operator="in" result="ShadowBlur"></feComposite>';
                                $section_divider_bottom .= '<feOffset in="ShadowBlur" result="dropShadow" dx="0" dy="' . $section_options['section_dropShadow_blur_y_offset_bottom'] . '"></feOffset>';
                                $section_divider_bottom .= '<feMerge>';
                                $section_divider_bottom .= '<feMergeNode in="dropShadow"></feMergeNode>';
                                $section_divider_bottom .= '<feMergeNode in="SourceGraphic"></feMergeNode>';
                                $section_divider_bottom .= '</feMerge>';
                                $section_divider_bottom .= '</filter>';
                            }
                            $section_divider_bottom .= '</defs>';
                        }
                        // END SVG Filter´s
                        if ($section_options['section_divider_bottom_dropshadow'] === "1") {
                            $section_divider_bottom .= '<g filter="url(#dropshadowfilter-bottom-section-' . $rdNr . ')">';
                            $section_divider_bottom .= $svg_paths_bottom;
                            $section_divider_bottom .= '</g>';
                        } else {
                            $section_divider_bottom .= $svg_paths_bottom;
                        }

                        $section_divider_bottom .= '</svg>';

                        // Inline CSS Bottom Divider
                        if (!empty($section_options['section_divider_bottom_height'])) {
                            $section_css .= '.ui-separator.ui-separator-bottom-' . $rdNr . '{height:' . $section_options['section_divider_bottom_height'] . 'px}';
                        }
                        $section_css .= '.ui-separator.ui-separator-bottom-' . $rdNr . ' path{' . $shape_paths_color_b . 'stroke-linecap:round}';
                    }
                    // END Section Dividers

                    // Section Background
                    if ($custom_background === "1") {
                        if (!empty($section_options['background_image']) || !empty($section_options['background_image_size'])) {
                            // Background srcset
                            if (!empty($section_options['background_image']) && $background_image_srcset === "1" && !empty($section_options['image_width_srcset'])) {
                                [$width, $height] = getimagesize(Uri::root() . $section_options['background_image']);
                                $ex        = '.' . pathinfo($section_options['background_image'], PATHINFO_EXTENSION);
                                $file_name = 'th_' . pathinfo($section_options['background_image'], PATHINFO_FILENAME);
                                // ratio
                                $ratio = round($width / $height * 100);

                                $type             = PageHelper::toArray($section);
                                $typeitem         = str_replace('_', '-', $type['type']) . 's';
                                $thumbnail_folder = 'media' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'ui-themebuilder-thumb' . DIRECTORY_SEPARATOR . $typeitem;

                                $tmp_srcset    = explode(',', $section_options['image_width_srcset']);
                                $merge_srcsets = array_merge($srcsets, $tmp_srcset);
                                $srcsets       = array_map('trim', $merge_srcsets);
                                $srcsets       = array_unique($srcsets);

                                $min_val = min($srcsets);

                                $srcset .= ' data-sizes="';
                                $srcset .= '(min-width:  ' . $min_val . 'px) 90vw, ';
                                $srcset .= '(max-width: ' . $width . 'px) 100vw, ';
                                $srcset .= '(max-aspect-ratio: ' . $width . '/' . $height . ') ' . $ratio . 'vh" ';
                                $srcset .= 'data-srcset="';

                                foreach ($srcsets as $i => $val) {
                                    if (is_numeric($val) && $val < 4000) {
                                        unset($srcsets[$i]);
                                        $srcset .= Uri::root() . $thumbnail_folder . '/' . $file_name . '_' . $val . $ex . ' ' . $val . 'w, ';
                                    }
                                }

                                $srcset .= Uri::root() . $section_options['background_image'] . ' ' . $width . 'w" ';
                                $srcset .= 'data-src="' . Uri::root() . $section_options['background_image'] . '"';
                                $srcset .= ' uk-img=""';
                            } elseif (!empty($section_options['background_image'])) {
                                $section_style['background-image'] = Uri::root() . $section_options['background_image'];
                                $srcset                            = '';
                            } else {
                                $section_style['background-image'] = 'https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg?' . time();
                                $srcset                            = '';
                            }

                            if (!empty($section_options['background_image_responsive']) && !empty($section_options['background_image'])) {
                                $section_classes .= ' ' . $section_options['background_image_responsive'];
                            }
                            if ($section_options['background_image_repeat'] === "0") {
                                $section_classes .= ' uk-background-norepeat';
                            }
                            if (!empty($section_options['background_image_size'])) {
                                $section_classes .= ' ' . $section_options['background_image_size'];
                            }

                            // Section Parallax Background Settings
                            if ($section_options['parallax_animation_background'] === "1") {
                                if (!empty($section_options['parallax_animation_media'])) {
                                    $parallax_attr_media = ' media: ' . $section_options['parallax_animation_media'] . ';';
                                } else {
                                    $parallax_attr_media = '';
                                }

                                if ($section_options['parallax_animation_background_viewport']) {
                                    $parallax_animation_background_viewport = ' viewport: ' . $section_options['parallax_animation_background_viewport'] . ';';
                                } else {
                                    $parallax_animation_background_viewport = '';
                                }

                                if (!empty($section_options['parallax_animation_background_x'])) {
                                    $parallax_x = 'bgx: ' . $section_options['parallax_animation_background_x'] . ';';
                                } else {
                                    $parallax_x = '';
                                }
                                if (!empty($section_options['parallax_animation_background_y'])) {
                                    $parallax_y = 'bgy: ' . $section_options['parallax_animation_background_y'] . ';';
                                } else {
                                    $parallax_y = '';
                                }

                                // Filters
                                if (!empty($section_options['parallax_animation_background_grayscale'])) {
                                    $parallax_animation_background_grayscale = ' grayscale: ' . $section_options['parallax_animation_background_grayscale'] . ';';
                                } else {
                                    $parallax_animation_background_grayscale = '';
                                }
                                if (!empty($section_options['parallax_animation_background_saturate'])) {
                                    $parallax_animation_background_saturate = ' saturate: ' . $section_options['parallax_animation_background_saturate'] . ';';
                                } else {
                                    $parallax_animation_background_saturate = '';
                                }
                                if (!empty($section_options['parallax_animation_background_color']) && !empty($section_options['background_color'])) {
                                    $parallax_animation_background_color = ' background-color: ' . $section_options['background_color'] . ',' . $section_options['parallax_animation_background_color'] . ';';
                                } else {
                                    $parallax_animation_background_color = '';
                                }

                                $section_parallax = ' uk-parallax="' . $parallax_x . $parallax_y . $parallax_attr_media . $parallax_animation_background_viewport . $parallax_animation_background_grayscale . $parallax_animation_background_saturate . $parallax_animation_background_color . '"';
                            } else {
                                $section_parallax                        = '';
                                $parallax_animation_background_color     = '';
                                $parallax_animation_background_grayscale = '';
                                $parallax_animation_background_saturate  = '';
                                $parallax_x                              = '';
                                $parallax_y                              = '';
                                $parallax_animation_background_viewport  = '';
                            }
                        }

                        if (!empty($section_options['background_color'])) {
                            $section_style['background-color'] = $section_options['background_color'];
                        }
                        if (!empty($section_options['background_color']) && !empty($section_options['background_image_blend_modes'])) {
                            $section_classes .= ' ' . $section_options['background_image_blend_modes'];
                        }

                        if (!empty($section_options['background_image']) && !empty($section_options['background_image_attachment'])) {
                            $section_classes .= ' ' . $section_options['background_image_attachment'];
                        }
                        if (!empty($section_options['background_image']) && !empty($section_options['background_image_position'])) {
                            $section_classes .= ' ' . $section_options['background_image_position'];
                        }

                        // Gradient Background
                    } elseif ($custom_background === "2") {
                        $color1 = ($section_options['gradient_color_1'] ?? '');
                        $color2 = ($section_options['gradient_color_2'] ?? '');
                        $color3 = ($section_options['gradient_color_3'] ?? '');

                        $color1_position = (isset($section_options['gradient_color_1_position']) ? $section_options['gradient_color_1_position'] . '%' : '');
                        $color2_position = (isset($section_options['gradient_color_2_position']) ? $section_options['gradient_color_2_position'] . '%' : '');
                        $color3_position = (isset($section_options['gradient_color_3_position']) ? $section_options['gradient_color_3_position'] . '%' : '');

                        $radial_conical_x_position = (isset($section_options['radial_conical_x_position']) ? $section_options['radial_conical_x_position'] . '%' : '');
                        $radial_conical_y_position = (isset($section_options['radial_conical_y_position']) ? $section_options['radial_conical_y_position'] . '%' : '');

                        // linear gradient
                        if ($section_options['gradient_effect'] === 'linear' && (!empty($color1) || !empty($color2) || !empty($color3))) {
                            $section_style['background-color'] = $color1; // Fallback color
                            // 3 active colors
                            if (!empty($color1) && !empty($color2) && !empty($color3)) {
                                $section_style['background'] = 'linear-gradient(' . $section_options['gradient_angle'] . 'deg, ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ', ' . $color3 . ' ' . $color3_position . ')';
                                // 2 active colors
                            } elseif (!empty($color1) && !empty($color2)) {
                                $section_style['background'] = 'linear-gradient(' . $section_options['gradient_angle'] . 'deg,' . $color1 . $color1_position . ', ' . $color2 . $color2_position . ')';
                            }
                            $section_style['background-attachment'] = 'scroll';

                            // radial gradient
                        } elseif ($section_options['gradient_effect'] === 'radial' && ((!empty($color1) && !empty($color2)) || !empty($color3)) && ($radial_conical_x_position && $radial_conical_y_position)) {
                            $section_style['background-color'] = $color1; // Fallback color
                            // 3 active colors
                            if (!empty($color1) && !empty($color2) && !empty($color3)) {
                                $section_style['background'] = 'radial-gradient(circle at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ', ' . $color3 . ' ' . $color3_position . ')';
                                // 2 active colors
                            } elseif (!empty($color1) && !empty($color2)) {
                                $section_style['background'] = 'radial-gradient(circle at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ')';
                            }
                            $section_style['background-attachment'] = 'scroll';

                            // conical gradient
                        } elseif ($section_options['gradient_effect'] === 'conical' && ((!empty($color1) && !empty($color2)) || !empty($color3)) && ($radial_conical_x_position && $radial_conical_y_position)) {
                            $section_style['background-color'] = $color1; // Fallback color
                            // 3 active colors
                            if (!empty($color1) && !empty($color2) && !empty($color3)) {
                                $section_style['background'] = 'conic-gradient(from ' . $section_options['gradient_angle'] . 'deg at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ', ' . $color3 . ' ' . $color3_position . ')';
                                // 2 active colors
                            } elseif (!empty($color1) && !empty($color2)) {
                                $section_style['background'] = 'conic-gradient(from ' . $section_options['gradient_angle'] . 'deg at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ')';
                            }
                        }

                        // SVG Background
                    } elseif ($custom_background === "3") {
                        if (!empty($section_options['section_svg_list'])) {
                            $svg_path                   = Uri::root() . $section_options['section_svg_list'];
                            $color_placeholder_1        = $section_options['section_svg_background_color_fallback'];
                            $color_placeholder_2        = $section_options['section_svg_background_color_2'];
                            $color_placeholder_3        = $section_options['section_svg_background_color_3'];
                            $text_placeholder           = $section_options['section_svg_background_text'];
                            $text_font_size_placeholder = $section_options['section_svg_background_text_font_size'] . 'px';
                            $opacity_placeholder        = $section_options['section_svg_background_image_opacity'];

                            $section_classes .= ' ui-section-svg-bg-' . $rdNr;
                            $section_classes .= ' ' . $section_svg_background_image_responsive;

                            // CSS output
                            $section_css .= '.ui-section-svg-bg-' . $rdNr . '{';
                            if (!empty($section_options['section_svg_background_color_fallback'])) {
                                $section_css .= 'background: ' . $section_options['section_svg_background_color_fallback'] . ';';
                                $section_css .= 'background-color: ' . $section_options['section_svg_background_color_fallback'] . ';';
                            }
                            if (!empty($section_options['section_svg_background_attachment'])) {
                                $section_css .= 'background-attachment: ' . $section_options['section_svg_background_attachment'] . ';';
                            }
                            if (!empty($section_options['section_svg_background_image_size'])) {
                                $section_css .= 'background-size: ' . $section_options['section_svg_background_image_size'] . ';';
                            }
                            if (!empty($section_options['section_svg_background_image_repeat'])) {
                                $section_css .= 'background-repeat: ' . $section_options['section_svg_background_image_repeat'] . ';';
                            }
                            if (!empty($section_options['section_svg_background_position_x']) && !empty($section_options['section_svg_background_position_y'])) {
                                $section_css .= 'background-position: ' . $section_options['section_svg_background_position_x'] . ' ' . $section_options['section_svg_background_position_y'] . ';';
                            }
                                $section_css .= 'background-image: url("data:image/svg+xml,' . PageHelper::convertSVGtoURI($svg_path, $rdNr, $color_placeholder_1, $color_placeholder_2, $color_placeholder_3, $text_placeholder, $text_font_size_placeholder, $opacity_placeholder) . '");';
                            $section_css .= '}';
                        }

                        // Shape Section Background
                    } elseif ($custom_background === "4") {
                        if (!empty($section_options['background_color']) && empty($section_options['shape_background'])) {
                            $section_style['background-color'] = $section_options['background_color'];
                        }

                        // default section background
                        if (!empty($section_options['shape_background'])) {
                            $section_classes .= ' ' . $section_options['shape_background'];
                        }

                        // square / circle shape
                        if (($section_options['shape'] === 'square' || $section_options['shape'] === 'circle') && ((!empty($section_options['shape_width']) && !empty($section_options['shape_height'])) || (!empty($section_options['shape_width_pixel']) && !empty($section_options['shape_height_pixel'])))) {
                            // CSS Class
                            if ($section_options['shape'] === 'square') {
                                $section_shape_class = 'ui-shape-square-' . $rdNr;
                            } elseif ($section_options['shape'] === 'circle') {
                                $section_shape_class = 'ui-shape-circle-' . $rdNr;
                            }
                            // CSS
                            $section_css .= '.' . $section_shape_class . '{';
                            // width & height pixel or %
                            if (!empty($section_options['shape_width']) && !empty($section_options['shape_height'])) {
                                $section_css .= 'width: ' . $section_options['shape_width'] . '%;';
                                $section_css .= 'height: ' . $section_options['shape_height'] . '%;';
                            } elseif (!empty($section_options['shape_width_pixel']) && !empty($section_options['shape_height_pixel'])) {
                                $section_css .= 'width: ' . $section_options['shape_width_pixel'] . 'px;';
                                $section_css .= 'height: ' . $section_options['shape_height_pixel'] . 'px;';
                            }
                            // background-color
                            if (!empty($section_options['shape_color'])) {
                                $section_css .= 'background-color: ' . $section_options['shape_color'] . ';';
                            } else {
                                $section_css .= 'background-color: transparent;';
                            }
                            // background-image
                            if (!empty($section_options['shape_background_image'])) {
                                $section_css .= 'background-image: url("' . Uri::root() . $section_options['shape_background_image'] . '");';
                                // image repeat
                                if ($shape_background_image_repeat === "0") {
                                    $section_css .= 'background-repeat: no-repeat;';
                                }
                                // image size
                                if (!empty($section_options['shape_background_image_size'])) {
                                    $section_css .= 'background-size: ' . $section_options['shape_background_image_size'] . ';';
                                }
                                // image blend modes
                                if (!empty($section_options['shape_background_image_blend_modes']) && !empty($section_options['shape_color'])) {
                                    $section_css .= 'background-blend-mode: ' . $section_options['shape_background_image_blend_modes'] . ';';
                                }
                                // image attachment
                                if ($shape_background_image_attachment === "fixed") {
                                    $section_css .= 'background-attachment: fixed;';
                                }
                            }
                            // position
                            $section_css .= 'top: 0;';
                            if ($shape_position === 'right') {
                                $section_css .= 'right: 0;';
                            } else {
                                $section_css .= 'left: 0;';
                            }
                            // margin
                            if (!$shape_margin_top || !$shape_margin_right || !$shape_margin_bottom || !$shape_margin_left) {
                                $section_css .= 'margin: ' . $shape_margin_top . ' ' . $shape_margin_right . ' ' . $shape_margin_bottom . ' ' . $shape_margin_left . ';';
                            }
                            // border
                            if ($shape_border && !empty($section_options['shape_border_style']) && !empty($section_options['shape_border_color'])) {
                                $section_css .= 'border: ' . $shape_border . ' ' . $section_options['shape_border_style'] . ' ' . $section_options['shape_border_color'] . ';';
                            }
                            if ($section_options['shape'] === 'circle') {
                                $section_css .= 'border-radius: 50%;';
                            }
                            // transform rotate
                            if ($shape_transform === 'rotate' && !empty($section_options['shape_transform_rotate'])) {
                                $section_css .= 'transform: rotate(' . $section_options['shape_transform_rotate'] . 'deg);';
                                // transform rotate3d
                            } elseif ($shape_transform === 'rotate3d' && !empty($section_options['shape_transform_rotate']) && !empty($section_options['shape_transform3d_1']) && !empty($section_options['shape_transform3d_2']) && !empty($section_options['shape_transform3d_3'])) {
                                $section_css .= 'transform: rotate3d(' . $section_options['shape_transform3d_1'] . ', ' . $section_options['shape_transform3d_2'] . ', ' . $section_options['shape_transform3d_3'] . ', ' . $section_options['shape_transform_rotate'] . 'deg);';
                            } else {
                                $section_css .= 'transform: unset;';
                            }
                            // z-index
                            if ($shape_position_zindex === "1") {
                                $section_css .= 'z-index: 1;';
                            } else {
                                $section_css .= 'z-index: 0;';
                            }
                            $section_css .= '}';

                            // triangle shape
                        } elseif ($section_options['shape'] === 'triangle' && !empty($section_options['shape_color'])) {
                            // CSS Class
                            $section_shape_class = 'ui-shape-triangle-' . $rdNr;

                            // CSS
                            $section_css .= '.' . $section_shape_class . '{';
                            // width & height
                            $section_css .= 'width: 0;';
                            $section_css .= 'height: 0;';

                            // background-color
                            $section_css .= 'background-color: transparent;';
                            // position
                            $section_css .= 'top: 0;';
                            if ($shape_position === 'right') {
                                $section_css .= 'right: 0;';
                            } else {
                                $section_css .= 'left: 0;';
                            }
                            // margin
                            if (!$shape_margin_top || !$shape_margin_right || !$shape_margin_bottom || !$shape_margin_left) {
                                $section_css .= 'margin: ' . $shape_margin_top . ' ' . $shape_margin_right . ' ' . $shape_margin_bottom . ' ' . $shape_margin_left . ';';
                            }
                            // border (build triangle)
                            if (!empty($section_options['shape_height_pixel'])) {
                                $section_css .= 'border-left: ' . $section_options['shape_height_pixel'] / 2 . 'px solid transparent;';
                                $section_css .= 'border-right: ' . $section_options['shape_height_pixel'] / 2 . 'px solid transparent;';
                                $section_css .= 'border-bottom: ' . $section_options['shape_height_pixel'] . 'px solid ' . $section_options['shape_color'] . ';';
                            }
                            // transform rotate
                            if ($shape_transform === 'rotate' && !empty($section_options['shape_transform_rotate'])) {
                                $section_css .= 'transform: rotate(' . $section_options['shape_transform_rotate'] . 'deg);';
                                // transform rotate3d
                            } elseif ($shape_transform === 'rotate3d' && !empty($section_options['shape_transform_rotate']) && !empty($section_options['shape_transform3d_1']) && !empty($section_options['shape_transform3d_2']) && !empty($section_options['shape_transform3d_3'])) {
                                $section_css .= 'transform: rotate3d(' . $section_options['shape_transform3d_1'] . ', ' . $section_options['shape_transform3d_2'] . ', ' . $section_options['shape_transform3d_3'] . ', ' . $section_options['shape_transform_rotate'] . 'deg);';
                            } else {
                                $section_css .= 'transform: unset;';
                            }
                            // z-index
                            if ($shape_position_zindex === "1") {
                                $section_css .= 'z-index: 1;';
                            } else {
                                $section_css .= 'z-index: 0;';
                            }
                            $section_css .= '}';
                        }
                        // Video Background
                    } elseif ($custom_background === "5") {
                        $section_video_classes   = ' ui-video-section-' . $rdNr;
                        $section_video_css_class = trim($section_video_classes);

                        $video_class      = '';
                        $video_params     = '';
                        $video_source     = '';
                        $video_src        = '';
                        $video_extensions = array ('asf', 'avi', 'flv', 'm4v', 'mp4', 'ogg', 'ogv', 'webm');
                        $video_url        = array ();

                        $video_auto_play        = ($section_options['video_auto_play'] ?? 1);
                        $video_show_controls    = ($section_options['video_show_controls'] ?? 1);
                        $video_show_suggestions = ($section_options['video_show_suggestions'] ?? 1);
                        $video_loop             = ($section_options['video_loop'] ?? 1);
                        $video_show_info        = ($section_options['video_show_info'] ?? 1);
                        $video_muted            = ($section_options['video_muted'] ?? 1);

                        // CSS output
                        $section_css .= '.' . $section_video_css_class . ' {';

                        $section_css .= 'top: 0;';
                        $section_css .= 'left: 0;';
                        $section_css .= 'z-index: 0;';

                        $section_css .= '}';

                        $video_url_tmp = ($section_options['video_url'] ?? 'https://www.youtube-nocookie.com/embed/YE7VzlLtp-4');
                        $video_url     = parse_url($video_url_tmp);

                        // Video autoplay params
                        if ($video_auto_play === "1") {
                            $video_params_autoplay = 'autoplay=1&amp;';
                            $ui_video              = '';
                        } else {
                            $video_params_autoplay = '';
                            $ui_video              = 'autoplay: inview';
                        }
                        // Video controls
                        if ($video_show_controls === "1") {
                            $video_params_controls = 'controls=1';
                        } else {
                            $video_params_controls = 'controls=0';
                        }
                        // Video suggestions
                        if ($video_show_suggestions === "1") {
                            $video_params_rel = 'rel=1';
                        } else {
                            $video_params_rel = 'rel=0';
                        }
                        // Video loop
                        if ($video_loop === "1") {
                            $video_params_loop = 'loop=1';
                        } else {
                            $video_params_loop = 'loop=0';
                        }
                        // Video info
                        if ($video_show_info === "1") {
                            $video_params_show_info = 'showinfo=1';
                        } else {
                            $video_params_show_info = 'showinfo=0';
                        }
                        // Video muted
                        if ($video_muted === "1") {
                            $muted           = 'automute: true';
                            $video_muted_url = '&amp;mute=1';
                        } else {
                            $video_muted_url = '&amp;mute=0';
                            $muted           = '&amp;mute=0';
                        }
                        // Video start at
                        if (!empty($section_options['video_start'])) {
                            $video_start = '&amp;start=' . $section_options['video_start'];
                        } else {
                            $video_start = '';
                        }
                        // Video iframe source
                        if (!empty($section_options['video_url'])) {
                            switch ($video_url['host']) {
                                case 'www.youtube-nocookie.com':
                                case 'youtube.com':
                                case 'www.youtube.com':
                                    $video_class = ' ui-youtube-video';
                                    $video_src   = $section_options['video_url'] . '?' . $video_params_autoplay . $video_params_controls . '&amp;' . $video_params_loop . '&amp;' . $video_params_show_info . '&amp;' . $video_params_rel . '&amp;iv_load_policy=3&amp;showsearch=0&amp;modestbranding=1' . $video_muted_url . '&amp;origin=' . Uri::root() . '&amp;playsinline=1' . $video_start;

                                    $video_source = '<div class="uk-visible@m uk-cover-container uk-position-absolute uk-width-1-1 uk-height-1-1 ' . $section_video_classes . $video_class . '" itemprop="video" itemscope="" itemtype="http://schema.org/VideoObject" uk-scrollspy="cls: uk-animation-fade; target: > *; delay: 250;">';
                                    if (!empty($section_options['thumbnail_image'])) {
                                        $video_source .= '<meta itemprop="thumbnailURL" content="' . Uri::root() . $section_options['thumbnail_image'] . '" />';
                                    }
                                    $video_source .= '<meta itemprop="embedURL" content="' . $section_options['video_url'] . '" />';
                                    $video_source .= '<iframe src="' . $video_src . '" frameborder="0" allow="accelerometer; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="" uk-responsive="" uk-cover="" uk-video="' . $ui_video . $muted . '"></iframe>';
                                    $video_source .= '</div>';

                                    break;

                                case 'vimeo.com':
                                case 'www.vimeo.com':
                                    if ($video_auto_play === "0") {
                                        $vimeoID = '';

                                        if (preg_match("/(https?:\/\/)?(www\.)?(player\.)?vimeo\.com\/?(showcase\/)*([0-9)([a-z]*\/)*([0-9]{6,11})[?]?.*/", $section_options['video_url'], $output_array)) {
                                            $vimeoID = $output_array[6];
                                        }

                                        $js =
                                            '
												$(document).ready(function() { 

													uiVimeoPlayer' . $rdNr . ' = uiVimeoPlayerLoadVideo("vimeoSection' . $rdNr . '",' . $vimeoID . ');
													uiVimeoPlayer' . $rdNr . '.pause();
													$(window).scroll(function(){ uiVimeoPlayerPlayPause("vimeoSection' . $rdNr . '" , uiVimeoPlayer' . $rdNr . '); });

														$("#btnPause").bind("click", function() {
															uiVimeoPlayer' . $rdNr . '.pause();
														});
														$("#btnPlay").bind("click", function() {
															uiVimeoPlayer' . $rdNr . '.play();
														});
												});
											';

                                        // $doc->addScriptDeclaration(trim(preg_replace('/^\s+|\n|\r|\s+$/m', '', $js)));
                                        $wa->addInlineScript(trim(preg_replace('/^\s+|\n|\r|\s+$/m', '', $js)), [], ['type' => 'module']);
                                    }

                                    $video_class = ' ui-vimeo-video';
                                    $video_src   = 'https://player.vimeo.com/video/' . basename($video_url['path']) . '?' . $video_params_autoplay . $video_params_loop . '&amp;title=0&amp;byline=0&amp;portrait=0';

                                    $video_source = '<div id="vimeoSection' . $rdNr . '" class="uk-visible@m uk-cover-container uk-position-absolute uk-width-1-1 uk-height-1-1 ' . $section_video_classes . $video_class . '" itemprop="video" itemscope="" itemtype="http://schema.org/VideoObject" uk-scrollspy="cls: uk-animation-fade; target: > *; delay: 250;">';
                                    if (!empty($section_options['thumbnail_image'])) {
                                        $video_source .= '<meta itemprop="thumbnailURL" content="' . Uri::root() . $section_options['thumbnail_image'] . '" />';
                                    }
                                    $video_source .= '<meta itemprop="embedURL" content="' . $section_options['video_url'] . '" />';
                                    $video_source .= '<iframe src="' . $video_src . '" frameborder="0" allow="accelerometer; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="" uk-responsive="" uk-cover="" uk-video="' . $muted . '"></iframe>';
                                    $video_source .= '</div>';

                                    break;

                                default:
                                    if (in_array(File::getExt($section_options['video_url']), $video_extensions)) {
                                        $video_class = ' default-video-player';
                                        // Video autoplay params
                                        if ($video_auto_play === "1") {
                                            $video_params_autoplay = ' autoplay ';
                                            $ui_video              = '';
                                        } else {
                                            $video_params_autoplay = ' ';
                                            $ui_video              = 'autoplay: inview';
                                        }
                                        // Video controls
                                        if ($video_show_controls === "1") {
                                            $video_params_controls = 'controls ';
                                        } else {
                                            $video_params_controls = '';
                                        }
                                        // Video loop
                                        if ($video_loop === "1") {
                                            $video_params_loop = 'loop ';
                                        } else {
                                            $video_params_loop = '';
                                        }
                                        // Video muted
                                        if ($video_muted === "1") {
                                            $muted = 'muted';
                                        } else {
                                            $muted = '';
                                        }

                                        $video_src = $section_options['video_url'];

                                        $video_source = '<div class="uk-visible@m uk-cover-container uk-position-absolute uk-width-1-1 uk-height-1-1 ' . $section_video_classes . $video_class . '" itemprop="video" itemscope="" itemtype="http://schema.org/VideoObject" uk-scrollspy="cls: uk-animation-fade; target: > *; delay: 250;">';
                                        if (!empty($section_options['thumbnail_image'])) {
                                            $video_source .= '<meta itemprop="thumbnailURL" content="' . Uri::root() . $section_options['thumbnail_image'] . '" />';
                                        }
                                        $video_source .= '<meta itemprop="embedURL" content="' . $section_options['video_url'] . '" />';
                                        $video_source .= '<video ' . $video_params_controls . $video_params_loop . $muted . ' playsinline' . $video_params_autoplay . 'uk-cover uk-video="' . $ui_video . '">';
                                        $video_source .= '<source src="' . $video_src . '" type="video/' . File::getExt($section_options['video_url']) . '">';
                                        $video_source .= '</video>';
                                        $video_source .= '</div>';
                                    }
                                    break;
                            }
                        }

                        // Default Section Background
                    } elseif (!empty($section_options['background'])) {
                        $section_classes .= ' ' . $section_options['background'];
                    }

                    // Section Mask Settings
                    $use_svg_custom_mask_size       = ($section_options['use_svg_custom_mask_size'] ?? 0);
                    $svg_mask_fill_color            = ($section_options['svg_mask__color'] ?? '#FFFFFF');
                    $svg_mask_mirrored_horizontally = ($section_options['svg_mask_mirrored_horizontally'] ?? 0);

                    if (!empty($section_options['svg_mask_list']) && ($custom_background === "1" || $custom_background === "2" || $custom_background === "3" || $custom_background === "5")) {
                        $section_mask_classes   = ' ui-mask-section-' . $rdNr;
                        $section_mask_css_class = trim($section_mask_classes);
                        $svg_mask_path          = Uri::root() . 'media/com_uithemebuilderlite/images/svg-masks/' . $section_options['svg_mask_list'];

                        if (empty($section_options['background_color']) && (!empty($section_options['svg_mask__color']))) {
                            $section_style['background-color'] = $section_options['svg_mask__color'];
                        }
                        // CSS output
                        $section_css .= '.' . $section_mask_css_class . ' {';
                            $section_css .= 'top: 0;';
                            $section_css .= 'left: 0;';
                            $section_css .= 'background-image: url("data:image/svg+xml,' . PageHelper::convertSVGtoURI($svg_mask_path, $rdNr, $svg_mask_fill_color) . '");';
                            $section_css .= 'background-repeat: ' . (isset($section_options['svg_mask_repeat']) ? $section_options['svg_mask_repeat'] . ';' : 'inherit;');
                        if ($use_svg_custom_mask_size === "0") {
                            $section_css .= 'background-size: ' . (isset($section_options['svg_mask_size']) ? $section_options['svg_mask_size'] . ';' : 'auto;');
                        } else {
                            $section_css .= 'background-size: ' . (isset($section_options['svg_custom_mask_size']) ? $section_options['svg_custom_mask_size'] . ';' : '100%;');
                        }
                        if ($svg_mask_mirrored_horizontally === "1") {
                            $section_css .= '-webkit-transform: scaleX(-1);';
                            $section_css .= 'transform: scaleX(-1);';
                        }

                            $section_css .= 'background-position: ' . (isset($section_options['svg_mask_position']) ? $section_options['svg_mask_position'] . ';' : 'center;');

                        $section_css .= '}';
                    }
                    // END Section Mask Settings

                    // build section styles
                    if (!empty($section_style)) {
                        $buildStyle = PageHelper::buildStyle($section_style);
                    }

                    // Section Container Position relative
                    if ((!empty($section_options['section_divider_bottom']) || !empty($section_options['section_divider_top'])) || ($custom_background === "4" && $section_options['shape'] !== '') || $section_key_show === "1" || !empty($section_options['svg_mask_list'])) {
                        $container_classes .= ' uk-position-relative';
                        $position_relative = ' uk-position-relative';
                    }

                    // Add Inline CSS SVGs Dividers / SVG Background / Shapes / Masks
                    if (!empty($section_css)) {
                        $inline_css_section = '<style>' . (trim(str_replace(array (
                                "\r\n",
                                "\r",
                                "\n",
                                '  '
                            ), '', $section_css))) . '</style>';
                    }
                    // END Section Backgrounds

                    // Section Grid
                    /*if ($grid_match === "1") {
                        $grid_match_attr = ' uk-height-match="' . $grid_match_target . $grid_match_row . '"';
                    } else {
                        $grid_match_attr = '';
                    }*/

                    if (!empty($section_options['grid_gutter'])) {
                        $grid_gutter_class .= ' ' . $section_options['grid_gutter'];
                    }
                    if (!empty($section_options['grid_row_gap'])) {
                        $grid_gutter_class .= ' ' . $section_options['grid_row_gap'];
                    }
                    if (!empty($section_options['grid_divider'])) {
                        $grid_gutter_class .= ' ' . $section_options['grid_divider'];
                    }
                    // END Section Grid


                    if ($section_options['section_height_viewport'] === "1") {
                        $section_classes .= ' ui-height-viewport';
                    }

                    if (!empty($section_options['color_style'])) {
                        $section_classes .= ' ' . $section_options['color_style'];
                    }

                    // Scrollspy Animation
                    $scrollspy_animation_attr = '';
                    // END Scrollspy Animation

                    // Parallax Animation
                    // Title
                    if ($section_options['parallax_animation_title'] === "1") {
                        if (!empty($section_options['parallax_animation_media'])) {
                            $parallax_attr_media = ' media: ' . $section_options['parallax_animation_media'] . ';';
                        } else {
                            $parallax_attr_media = '';
                        }

                        if (!empty($section_options['parallax_animation_title_opacity_values'])) {
                            $parallax_attr_title_opacity = 'opacity: ' . $section_options['parallax_animation_title_opacity_values'] . ';';
                        } else {
                            $parallax_attr_title_opacity = '';
                        }

                        if (!empty($section_options['parallax_animation_title_y_values'])) {
                            $parallax_attr_title_y = ' y: ' . $section_options['parallax_animation_title_y_values'] . ';';
                        } else {
                            $parallax_attr_title_y = '';
                        }

                        if (!empty($section_options['parallax_animation_title_x_values'])) {
                            $parallax_attr_title_x = ' x: ' . $section_options['parallax_animation_title_x_values'] . ';';
                        } else {
                            $parallax_attr_title_x = '';
                        }

                        if (!empty($section_options['parallax_animation_title_scale_values'])) {
                            $parallax_attr_title_scale = ' scale: ' . $section_options['parallax_animation_title_scale_values'] . ';';
                        } else {
                            $parallax_attr_title_scale = '';
                        }

                        if ($section_options['parallax_animation_title_viewport']) {
                            $parallax_attr_title_viewport = ' viewport: ' . $section_options['parallax_animation_title_viewport'] . ';';
                        } else {
                            $parallax_attr_title_viewport = '';
                        }

                        $parallax_attr_title = ' uk-parallax="' . $parallax_attr_title_opacity . $parallax_attr_title_y . $parallax_attr_title_x . $parallax_attr_title_scale . $parallax_attr_media . $parallax_attr_title_viewport . '"';
                    } else {
                        $parallax_attr_title = '';
                    }

                    // SubTitle
                    if ($section_options['parallax_animation_subtitle'] === "1") {
                        if (!empty($section_options['parallax_animation_media'])) {
                            $parallax_attr_subtitle_media = ' media: ' . $section_options['parallax_animation_media'] . ';';
                        } else {
                            $parallax_attr_subtitle_media = '';
                        }

                        if (!empty($section_options['parallax_animation_subtitle_opacity_values'])) {
                            $parallax_attr_subtitle_opacity = 'opacity: ' . $section_options['parallax_animation_subtitle_opacity_values'] . ';';
                        } else {
                            $parallax_attr_subtitle_opacity = '';
                        }

                        if (!empty($section_options['parallax_animation_subtitle_y_values'])) {
                            $parallax_attr_subtitle_y = ' y: ' . $section_options['parallax_animation_subtitle_y_values'] . ';';
                        } else {
                            $parallax_attr_subtitle_y = '';
                        }

                        if (!empty($section_options['parallax_animation_subtitle_x_values'])) {
                            $parallax_attr_subtitle_x = ' x: ' . $section_options['parallax_animation_subtitle_x_values'] . ';';
                        } else {
                            $parallax_attr_subtitle_x = '';
                        }

                        if (!empty($section_options['parallax_animation_subtitle_scale_values'])) {
                            $parallax_attr_subtitle_scale = ' scale: ' . $section_options['parallax_animation_subtitle_scale_values'] . ';';
                        } else {
                            $parallax_attr_subtitle_scale = '';
                        }

                        if ($section_options['parallax_animation_subtitle_viewport']) {
                            $parallax_attr_subtitle_viewport = ' viewport: ' . $section_options['parallax_animation_subtitle_viewport'] . ';';
                        } else {
                            $parallax_attr_subtitle_viewport = '';
                        }

                        $parallax_attr_subtitle = ' uk-parallax="' . $parallax_attr_subtitle_opacity . $parallax_attr_subtitle_y . $parallax_attr_subtitle_x . $parallax_attr_subtitle_scale . $parallax_attr_subtitle_media . $parallax_attr_subtitle_viewport . '"';
                    } else {
                        $parallax_attr_subtitle = '';
                    }
                    // END Parallax Animation

                    if (isset($section_options['title']) && !empty($section_options['title'])) {
                        $section_title = PageHelper::escapeHtml($section_options['title']);
                    } else {
                        $section_title = Text::_('COM_UITHEMEBUILDERLITE_SECTION');
                    } ?>

                    <div id="section" class="section-container">

                        <div class="section-tools uk-position-absolute uk-position-top-left uk-width-1-1">
                            <div uk-grid="" class="uk-grid-small">
                                <div class="uk-width-auto">
                                    <div class="uk-panel">
                                        <ul class="uk-iconnav">
                                            <li class="uk-drag move-section" uk-tooltip="<?php echo $section_title; ?>">
                                                <i class="uk-text-emphasis uk-margin-small-top uk-margin-small-left uk-icon-button uk-drag<?php echo $section_admin_visibility; ?>"
                                                   uk-icon="move"></i>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="uk-width-expand">
                                    <div class="uk-flex uk-flex-right">
                                        <div class="uk-panel uk-overlay uk-overlay-primary uk-padding-small">
                                            <div uk-grid="" class="uk-grid-small uk-flex-middle">
                                                <?php $rn = PageHelper::randomNumber() . $key; ?>
                                                <div id="section-options-toggle-1<?php echo $rn; ?>"
                                                     class="section-options-toggle uk-width-expand" hidden="">
                                                    <div uk-grid="" class="uk-flex-middle">

                                                        <div class="uk-width-expand">
                                                            <ul class="uk-iconnav section-actions">

                                                                <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_SAVE_SECTION'); ?>">
                                                                    <a class="btn-save-section"
                                                                       href="javascript:void(0)"><i
                                                                            uk-icon="ui-save"></i></a></li>
                                                                <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_ADD_ROW'); ?>">
                                                                    <a class="btn-add-section"
                                                                       href="javascript:void(0)"><i
                                                                            uk-icon="ui-section"></i></a></li>
                                                                <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_DUPLICATE_ROW'); ?>">
                                                                    <a class="btn-duplicate-section"
                                                                       href="javascript:void(0)"><i uk-icon="copy"></i></a>
                                                                </li>
                                                                <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_CONFIGURE_ROW'); ?>">
                                                                    <a class="btn-config-section"
                                                                       href="javascript:void(0)"><i
                                                                            uk-icon="cog"></i></a></li>
                                                                <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_DELETE_ROW'); ?>">
                                                                    <a class="btn-delete-section"
                                                                       href="javascript:void(0)"><i uk-icon="trash"></i></a>
                                                                </li>
                                                                <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_ADD_MANAGE_COLUMNS'); ?>">
                                                                    <a class="btn-manage-columns btn-manage-columns<?php echo $rn; ?> uk-text-muted"
                                                                       href="javascript:void(0)"><i
                                                                            uk-icon="ui-columns"></i></a>
                                                                    <div id="manage-columns-dropdown<?php echo $rn; ?>"
                                                                         class="manage-columns-dropdown manage-columns-dropdown<?php echo $rn; ?> uk-background-secondary uk-light"
                                                                         uk-dropdown="mode: click; pos: top-right; toggle: .btn-manage-columns<?php echo $rn; ?>">
                                                                        <div class="uk-width-xlarge">
                                                                            <div
                                                                                class="uk-margin-small uk-height-max-medium"
                                                                                uk-overflow-auto>
                                                                                <ul class="uk-grid-medium uk-child-width-1-1@s uk-child-width-1-4@m uk-flex-center uk-margin grids"
                                                                                    uk-grid="">
                                                                                    <li>
                                                                                        <div
                                                                                            class="grid-default<?php echo(($section['grid'] === "1-1") ? ' active-grid uk-background-primary uk-light' : ''); ?>"
                                                                                            data-grid="1-1"
                                                                                            uk-tooltip="1-1 (whole)">
                                                                                            <img
                                                                                                src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#whole"
                                                                                                uk-svg
                                                                                                alt="1-1 (whole)">
                                                                                        </div>
                                                                                    </li>
                                                                                    <li>
                                                                                        <div
                                                                                            class="grid-default<?php echo(($section['grid'] === "1-2,1-2") ? ' active-grid uk-background-primary uk-light' : ''); ?>"
                                                                                            data-grid="1-2;1-2"
                                                                                            uk-tooltip="1-2;1-2 (halves)">
                                                                                            <img
                                                                                                src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#halves"
                                                                                                uk-svg
                                                                                                alt="1-2;1-2 (halves)">
                                                                                        </div>
                                                                                    </li>
                                                                                    <li>
                                                                                        <div
                                                                                            class="grid-default<?php echo(($section['grid'] === "1-3,1-3,1-3") ? ' active-grid uk-background-primary uk-light' : ''); ?>"
                                                                                            data-grid="1-3;1-3;1-3"
                                                                                            uk-tooltip="1-3;1-3;1-3 (thirds)">
                                                                                            <img
                                                                                                src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#thirds"
                                                                                                uk-svg
                                                                                                alt="1-3;1-3;1-3 (thirds)">
                                                                                        </div>
                                                                                    </li>
                                                                                    <li>
                                                                                        <div
                                                                                            class="grid-default<?php echo(($section['grid'] === "1-4,1-4,1-4,1-4") ? ' active-grid uk-background-primary uk-light' : ''); ?>"
                                                                                            data-grid="1-4;1-4;1-4;1-4"
                                                                                            uk-tooltip="1-4;1-4;1-4;1-4 (quarters)">
                                                                                            <img
                                                                                                src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#quarters"
                                                                                                uk-svg
                                                                                                alt="1-4;1-4;1-4;1-4 (quarters)">
                                                                                        </div>
                                                                                    </li>
                                                                                    <li>
                                                                                        <div
                                                                                            class="grid-default<?php echo(($section['grid'] === "auto,expand,whole") ? ' active-grid uk-background-primary uk-light' : ''); ?>"
                                                                                            data-grid="auto;expand;1-1"
                                                                                            uk-tooltip="auto;expand;1-1">
                                                                                            <img
                                                                                                src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#auto-expand-whole"
                                                                                                uk-svg
                                                                                                alt="auto;expand;1-1">
                                                                                        </div>
                                                                                    </li>
                                                                                    <li>
                                                                                        <div
                                                                                            class="grid-default<?php echo(($section['grid'] === "expand,1-2,expand") ? ' active-grid uk-background-primary uk-light' : ''); ?>"
                                                                                            data-grid="expand;1-2;expand"
                                                                                            uk-tooltip="expand;1-2;expand">
                                                                                            <img
                                                                                                src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#expand-1-2-expand"
                                                                                                uk-svg
                                                                                                alt="expand;1-2;expand">
                                                                                        </div>
                                                                                    </li>
                                                                                    <li>
                                                                                        <div
                                                                                            class="grid-default<?php echo(($section['grid'] === "expand,2-3") ? ' active-grid uk-background-primary uk-light' : ''); ?>"
                                                                                            data-grid="expand;2-3"
                                                                                            uk-tooltip="expand;2-3">
                                                                                            <img
                                                                                                src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#expand-2-3"
                                                                                                uk-svg alt="expand;2-3">
                                                                                        </div>
                                                                                    </li>
                                                                                    <li>
                                                                                        <div
                                                                                            class="grid-default<?php echo(($section['grid'] === "expand,large,expand") ? ' active-grid uk-background-primary uk-light' : ''); ?>"
                                                                                            data-grid="expand;large;expand"
                                                                                            uk-tooltip="expand;large;expand">
                                                                                            <img
                                                                                                src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#expand-large-expand"
                                                                                                uk-svg
                                                                                                alt="expand;large;expand">
                                                                                        </div>
                                                                                    </li>
                                                                                    <li class="uk-hidden">
                                                                                        <div
                                                                                            class="grid-default custom-grid<?php echo(($section['grid'] === "1-1" || $section['grid'] === "1-2,1-2" || $section['grid'] === "1-3,1-3,1-3" || $section['grid'] === "1-4,1-4,1-4,1-4" || $section['grid'] === "auto,expand,whole" || $section['grid'] === "expand,1-2,expand" || $section['grid'] === "expand,2-3" || $section['grid'] === "expand,large,expand") ? '' : ' active-grid'); ?>"
                                                                                            data-grid="<?php $section_grid = str_replace(',', ';', $section['grid']);
                                                                                            echo $section_grid; ?>">
                                                                                        </div>
                                                                                    </li>
                                                                                </ul>
                                                                            </div>
                                                                            <div class="uk-padding-small">
                                                                                <div class="uk-flex uk-flex-center">
                                                                                    <div class="uk-flex uk-flex-middle">
                                                                                        <span
                                                                                            class="uk-text-small uk-margin-small-right uk-text-muted"><?php echo Text::_('COM_UITHEMEBUILDERLITE_CUSTOM_GRID'); ?></span>
                                                                                        <div class="uk-width-expand">
                                                                                            <div class="uk-inline">
                                                                                                <a class="uk-form-icon uk-form-icon-flip btn-generate-layout"
                                                                                                   href="javascript:void(0)"
                                                                                                   uk-icon="ui-columns"></a>
                                                                                                <input type="text"
                                                                                                       class="uk-input"
                                                                                                       name="custom_layout"
                                                                                                       placeholder="expand;2-3"
                                                                                                       value="">
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </li>
                                                                <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_TOGGLE_SECTION'); ?>">
                                                                    <a class="btn-toggle-section"
                                                                       href="#ui-section-1<?php echo $key; ?>"
                                                                       uk-toggle="animation: uk-animation-slide-left, uk-animation-fade;"><i
                                                                            uk-icon="chevron-down"></i></a></li>
                                                                <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_DISABLE_SECTION'); ?>">
                                                                    <a class="btn-disable-section"
                                                                       href="javascript:void(0)"<?php echo(($section['admin_visibility'] === '0') ? ' uk-icon="lock"' : ' uk-icon="unlock"'); ?>></a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="uk-width-auto">
                                                    <ul class="uk-iconnav">
                                                        <li title="" tabindex="0" uk-tooltip="Toggle Section Options">
                                                            <a class="btn-toggle-section-options"
                                                               href="javascript:void(0)"
                                                               uk-toggle="target: #section-options-toggle-1<?php echo $rn; ?>">
                                                                <i uk-icon="more-vertical"></i>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php
                        // Section HTML output
                        $html .= '<' . $section_options['html_tag'] . ' id="ui-section-1' . $key . '" class="ui-section uk-section uk-position-relative' . $section_classes . '"' . $section_parallax . $scrollspy_animation_attr . /* $section_height_viewport .  */
                            $srcset . $buildStyle . '>';

                        // SVG dividers
                        $html .= $section_divider_top;
                        $html .= $section_divider_bottom;

                        // visible section number
                        if ($section_key_show === "1" && isset($section_options['section_key_position'])) {
                            $add_key = $key + 1;
                            // opacity style
                            if (!empty($section_options['section_key_opacity']) && isset($section_options['section_key_opacity'])) {
                                $section_key_style['opacity'] = $section_options['section_key_opacity'];
                            }
                            // font-size style
                            if (!empty($section_options['section_key_font_size']) && isset($section_options['section_key_font_size'])) {
                                $section_key_style['font-size'] = $section_options['section_key_font_size'] . '%';
                            }
                            // build inline styles
                            if (!empty($section_key_style)) {
                                $section_key_buildStyle = PageHelper::buildStyle($section_key_style);
                            }

                            $html .= '<div class="uk-visible@m">';
                            if ($key <= 8) {
                                $html .= '<div class="uk-position-large uk-position-' . $section_options['section_key_position'] . ' uk-text-bold ui-section-key" ' . $section_key_buildStyle . '>0' . $add_key . '</div>';
                            } else {
                                $html .= '<div class="uk-position-large uk-position-' . $section_options['section_key_position'] . ' uk-text-bold ui-section-key" ' . $section_key_buildStyle . '>' . $add_key . '</div>';
                            }
                            $html .= '</div>';
                        }

                        // Section Video Background
                        if ($custom_background === "5" && !empty($section_options['video_url'])) {
                            $html .= $video_source;
                        }

                        // Section Mask
                        if (isset($section_options['svg_mask_list']) && !empty($section_options['svg_mask_list'])) {
                            $html .= '<div class="uk-visible@m uk-position-absolute uk-width-1-1 uk-height-1-1 ' . $section_mask_classes . '"></div>';
                        }

                        // Section Shapes
                        if ($custom_background === "4" && !empty($section_options['shape'])) {
                            $html .= '<div class="uk-visible@m uk-position-absolute ' . $section_shape_class . $shape_shadow . $shape_background_image_position . '"></div>';
                        }

                        if (($section_full_width === "0") && !empty($section_options['container_width'])) {
                            $container_classes .= ' ' . $section_options['container_width'];
                            $html              .= '<div class="uk-container' . $container_classes . '"' . $container_buildStyle . '>';
                        }

                        if (($section_options['section_load_components'] === "0") && ($section_options['heading_alignment'] === 'uk-text-center') && ($section_options['section_height_viewport'] === "1")) {
                            if ((!empty($section_options['title']) || !empty($section_options['subtitle'])) && ($title_show === "1" && $section_options['use_svg_title'] === "0")) {
                                if (!empty($section_options['heading_alignment'])) {
                                    $heading_alignment = ' ' . $section_options['heading_alignment'];
                                }
                                $html .= '<div class="' . trim($grid_gutter_class) . $position_relative . '" uk-grid="">';
                                $html .= '<div class="uk-width-1-1">';
                                $html .= '<div class="uk-position-center uk-flex uk-flex-center uk-flex-middle ' . $heading_alignment . '">';
                                $html .= '<div class="uk-margin-auto uk-margin-auto-vertical uk-width-auto">';
                                if (!empty($section_options['title'])) {
                                    if (!empty($section_options['subtitle'])) {
                                        $title_class .= ' uk-margin-remove';
                                    }
                                    $html .= '<' . $section_options['title_heading'] . ' class="' . trim($title_class) . '"' . $parallax_attr_title . '>';
                                    $html .= '<span>' . $section_options['title'] . '</span>';
                                    $html .= '</' . $section_options['title_heading'] . '>';
                                }
                                if (!empty($section_options['subtitle'])) {
                                    if (!empty($section_options['title'])) {
                                        $subtitleMargin = ' uk-margin-small-top';
                                    }
                                    $html .= '<' . $section_options['subtitle_heading'] . ' class="' . trim($subtitleMargin . $subtitle_class) . '"' . $parallax_attr_subtitle . '>';
                                    $html .= '<span>' . $section_options['subtitle'] . '</span>';
                                    $html .= '</' . $section_options['subtitle_heading'] . '>';
                                }
                                $html .= '</div>';
                                $html .= '</div>';
                                $html .= '</div>';
                                $html .= '</div>';
                            } elseif ((!empty($section_options['title']) || !empty($section_options['subtitle'])) && ($title_show === "1" && $section_options['use_svg_title'] === "1")) {
                                // SVG Title/Subtitle Style -Viewport-height
                                // Title Stroke Settings
                                if ($section_options['svg_title_stroke'] === "1") {
                                    if (!empty($section_options['svg_title_stroke_fill_color'])) {
                                        $fill_stroke = ' fill-stroke="' . $section_options['svg_title_stroke_fill_color'] . '"';
                                    } else {
                                        $fill_stroke = '';
                                    }
                                    if (!empty($section_options['svg_title_stroke_color'])) {
                                        $stroke = ' stroke="' . $section_options['svg_title_stroke_color'] . '"';
                                    } else {
                                        $stroke = '';
                                    }
                                    if (!empty($section_options['svg_title_stroke_width'])) {
                                        $stroke_width = ' stroke-width="' . $section_options['svg_title_stroke_width'] . '"';
                                    } else {
                                        $stroke_width = '';
                                    }

                                    $title_stroke = $fill_stroke . $stroke . $stroke_width;
                                } else {
                                    $title_stroke = '';
                                }

                                // Subtitle Stroke Settings
                                if ($section_options['svg_subtitle_stroke'] === "1") {
                                    if (!empty($section_options['svg_subtitle_stroke_fill_color'])) {
                                        $sub_fill_stroke = ' fill-stroke="' . $section_options['svg_subtitle_stroke_fill_color'] . '"';
                                    } else {
                                        $sub_fill_stroke = '';
                                    }
                                    if (!empty($section_options['svg_subtitle_stroke_color'])) {
                                        $sub_stroke = ' stroke="' . $section_options['svg_subtitle_stroke_color'] . '"';
                                    } else {
                                        $sub_stroke = '';
                                    }
                                    if (!empty($section_options['svg_subtitle_stroke_width'])) {
                                        $sub_stroke_width = ' stroke-width="' . $section_options['svg_subtitle_stroke_width'] . '"';
                                    } else {
                                        $sub_stroke_width = '';
                                    }

                                    $sub_title_stroke = $sub_fill_stroke . $sub_stroke . $sub_stroke_width;
                                } else {
                                    $sub_title_stroke = '';
                                }
                                $html .= '<svg class="ui-svg-title uk-position-cover" width="100%" height="100%"' . $section_height_viewport . ' xmlns="http://www.w3.org/2000/svg">';
                                $html .= '<defs>';
                                $html .= '<mask id="text-mask-' . $rdNr . '">';
                                $html .= '<rect width="100%" height="100%" fill="' . $section_options['mask_color'] . '" />';
                                $html .= '<g id="text-' . $rdNr . '">';
                                if (!empty($section_options['title'])) {
                                    $html .= '<text text-anchor="middle" x="' . $section_options['title_position_x'] . '%" y="' . $section_options['title_position_y'] . '%" id="svgTitle" class="' . trim($title_class) . '"' . $title_stroke . $parallax_attr_title . '>' . $section_options['title'] . '</text>';
                                }
                                if (!empty($section_options['subtitle'])) {
                                    $html .= '<text text-anchor="middle" x="' . $section_options['subtitle_position_x'] . '%" y="' . $section_options['subtitle_position_y'] . '%" id="svgSubtitle" class="' . trim($subtitle_class) . '"' . $sub_title_stroke . $parallax_attr_subtitle . '>' . $section_options['subtitle'] . '</text>';
                                }
                                $html .= '</g>';
                                $html .= '</mask>';
                                $html .= '</defs>';
                                $html .= '<rect id="base" x="0" y="0" width="100%" height="100%" fill="' . $section_options['mask_color_output'] . '" mask="url(#text-mask-' . $rdNr . ')" />';
                                $html .= '</svg>';
                            }
                        } elseif ((!empty($section_options['title']) || !empty($section_options['subtitle'])) && ($title_show === "1" && $section_options['use_svg_title'] === "0")) {
                            if (!empty($section_options['heading_alignment'])) {
                                $heading_alignment = ' ' . $section_options['heading_alignment'];
                            }
                            $html .= '<div class="' . $grid_gutter_class . $position_relative . '" uk-grid="">';
                            $html .= '<div class="uk-width-1-1">';
                            $html .= '<div class="uk-padding-small' . $heading_alignment . '">';
                            if (!empty($section_options['title'])) {
                                if (!empty($section_options['subtitle'])) {
                                    $title_class .= ' uk-margin-remove';
                                }
                                $html .= '<' . $section_options['title_heading'] . ' class="' . trim($titleMargin . $title_class) . '"' . $parallax_attr_title . '>';
                                $html .= '<span>' . $section_options['title'] . '</span>';
                                $html .= '</' . $section_options['title_heading'] . '>';
                            }
                            if (!empty($section_options['subtitle'])) {
                                if (!empty($section_options['title'])) {
                                    $subtitleMargin = ' uk-margin-small-top';
                                }
                                $html .= '<' . $section_options['subtitle_heading'] . ' class="' . trim($subtitleMargin . $subtitle_class) . '"' . $parallax_attr_subtitle . '>';
                                $html .= '<span>' . $section_options['subtitle'] . '</span>';
                                $html .= '</' . $section_options['subtitle_heading'] . '>';
                            }
                            $html .= '</div>';
                            $html .= '</div>';
                            $html .= '</div>';
                        } elseif ((!empty($section_options['title']) || !empty($section_options['subtitle'])) && ($title_show === "1" && $section_options['use_svg_title'] === "1")) {
                            // SVG Title/Subtitle Style
                            // Title Stroke Settings
                            if ($section_options['svg_title_stroke'] === "1") {
                                if (!empty($section_options['svg_title_stroke_fill_color'])) {
                                    $fill_stroke = ' fill-stroke="' . $section_options['svg_title_stroke_fill_color'] . '"';
                                } else {
                                    $fill_stroke = '';
                                }
                                if (!empty($section_options['svg_title_stroke_color'])) {
                                    $stroke = ' stroke="' . $section_options['svg_title_stroke_color'] . '"';
                                } else {
                                    $stroke = '';
                                }
                                if (!empty($section_options['svg_title_stroke_width'])) {
                                    $stroke_width = ' stroke-width="' . $section_options['svg_title_stroke_width'] . '"';
                                } else {
                                    $stroke_width = '';
                                }

                                $title_stroke = $fill_stroke . $stroke . $stroke_width;
                            } else {
                                $title_stroke = '';
                            }

                            // Subtitle Stroke Settings
                            if ($section_options['svg_subtitle_stroke'] === "1") {
                                if (!empty($section_options['svg_subtitle_stroke_fill_color'])) {
                                    $sub_fill_stroke = ' fill-stroke="' . $section_options['svg_subtitle_stroke_fill_color'] . '"';
                                } else {
                                    $sub_fill_stroke = '';
                                }
                                if (!empty($section_options['svg_subtitle_stroke_color'])) {
                                    $sub_stroke = ' stroke="' . $section_options['svg_subtitle_stroke_color'] . '"';
                                } else {
                                    $sub_stroke = '';
                                }
                                if (!empty($section_options['svg_subtitle_stroke_width'])) {
                                    $sub_stroke_width = ' stroke-width="' . $section_options['svg_subtitle_stroke_width'] . '"';
                                } else {
                                    $sub_stroke_width = '';
                                }

                                $sub_title_stroke = $sub_fill_stroke . $sub_stroke . $sub_stroke_width;
                            } else {
                                $sub_title_stroke = '';
                            }

                            $html .= '<svg class="ui-svg-title uk-height-' . $section_options['mask_height'] . '" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg">';
                            $html .= '<defs>';
                            $html .= '<mask id="text-mask-' . $rdNr . '">';
                            $html .= '<rect width="100%" height="100%" fill="' . $section_options['mask_color'] . '" />';
                            $html .= '<g id="text-' . $rdNr . '">';
                            if (!empty($section_options['title'])) {
                                $html .= '<text text-anchor="middle" x="' . $section_options['title_position_x'] . '%" y="' . $section_options['title_position_y'] . '%" id="svgTitle" class="' . trim($title_class) . '"' . $title_stroke . $parallax_attr_title . '>' . $section_options['title'] . '</text>';
                            }
                            if (!empty($section_options['subtitle'])) {
                                $html .= '<text text-anchor="middle" x="' . $section_options['subtitle_position_x'] . '%" y="' . $section_options['subtitle_position_y'] . '%" id="svgSubtitle" class="' . trim($subtitle_class) . '"' . $sub_title_stroke . $parallax_attr_subtitle . '>' . $section_options['subtitle'] . '</text>';
                            }
                            $html .= '</g>';
                            $html .= '</mask>';
                            $html .= '</defs>';
                            $html .= '<rect id="base" x="0" y="0" width="100%" height="100%" fill="' . $section_options['mask_color_output'] . '" mask="url(#text-mask-' . $rdNr . ')" />';
                            $html .= '</svg>';
                        }
                        // END Title/Subtitle Settings

                        $html .= '<div class="ui-columns ' . trim($grid_gutter_class) . $position_relative . '" uk-grid="" uk-sortable="handle: .uk-drag.move-column; group: sortable-column-group-1' . $key . '"' . $scrollspy_animation_attr . '>';

                        foreach ($section['columns'] as $column_index => $column) {
                            $column                   = PageHelper::toArray($column);
                            $column_options           = PageHelper::escapeHtmlArray($column['options']);
                            $title_show               = ($column_options['title_show'] ?? 1);
                            $heading_alignment        = '';
                            $column_grid_gutter_class = '';
                            $column_heading_alignment = ' class="uk-padding-small uk-padding-remove-vertical"';

                            $title_show                 = ($column_options['title_show'] ?? 1);
                            $flex_column_items_vertical = (isset($column_options['flex_column_items_vertical']) && !empty($column_options['flex_column_items_vertical']) ? ' ' . $column_options['flex_column_items_vertical'] : '');

                            $custom_column_background = (isset($column_options['custom_background']) && $column_options['custom_background'] ? $column_options['custom_background'] : "0");
                            $key                      = $column_index . PageHelper::randomNumber();
                            $column_css               = '';
                            $column_class             = '';
                            $inlineColumnCss          = '';


                            $shape_position      = ($column_options['shape_position'] ?? 'left');
                            $shape_margin_top    = ((isset($column_options['shape_margin_top']) && !empty($column_options['shape_margin_top'])) ? $column_options['shape_margin_top'] . 'px' : 0);
                            $shape_margin_right  = ((isset($column_options['shape_margin_right']) && !empty($column_options['shape_margin_right'])) ? $column_options['shape_margin_right'] . 'px' : 0);
                            $shape_margin_bottom = ((isset($column_options['shape_margin_bottom']) && !empty($column_options['shape_margin_bottom'])) ? $column_options['shape_margin_bottom'] . 'px' : 0);
                            $shape_margin_left   = ((isset($column_options['shape_margin_left']) && !empty($column_options['shape_margin_left'])) ? $column_options['shape_margin_left'] . 'px' : 0);

                            $shape_position_zindex = ($column_options['shape_position_zindex'] ?? 0);
                            $shape_border          = ((isset($column_options['shape_border']) && !empty($column_options['shape_border'])) ? $column_options['shape_border'] . 'px' : '');
                            $shape_transform       = ($column_options['shape_transform'] ?? 'unset');
    //                              $shape_shadow = ((isset($column_options['shape_shadow']) && !empty($column_options['shape_shadow'])) ? ' ' . $column_options['shape_shadow'] : '');

                            $shape_background_image_repeat     = ($column_options['shape_background_image_repeat'] ?? 0);
                            $shape_background_image_attachment = ($column_options['shape_background_image_attachment'] ?? "");
                            $shape_background_image_position   = ((isset($column_options['shape_background_image_position']) && !empty($column_options['shape_background_image_position']) && !empty($column_options['shape_background_image'])) ? ' ' . $column_options['shape_background_image_position'] : '');


                            if (!empty($column_options['id'])) {
                                $column_id = ' id="' . $column_options['id'] . '"';
                            } else {
                                $column_id = '';
                            }
                            if (!empty($column_options['class'])) {
                                $column_class .= ' ' . $column_options['class'];
                            }

                            // Add Column Background
                            if ($custom_column_background === "1") {
                                // default column background
                                if (!empty($column_options['background_color'])) {
                                    $column_css .= '.ui-column-' . $key . '{';
                                    $column_css .= 'position: relative;';
                                    $column_css .= '}';

                                    if (!empty($flex_column_items_vertical)) {
                                        $column_css .= '.ui-column-' . $key . '::before{';
                                    } else {
                                        $column_css .= '.ui-column-' . $key . '::before{';
                                    }

                                    $column_css .= 'content: "";';
                                    $column_css .= 'position: absolute;';
                                    $column_css .= 'top: 0;';
                                    $column_css .= 'left: 40px;';
                                    $column_css .= 'width: calc(100% - 55px);';
                                    $column_css .= 'height: 100%;';
                                    // $column_css .= 'z-index: -2;';
                                    $column_css .= 'background-color: ' . $column_options['background_color'] . ';';
                                    $column_css .= '}';

                                    $column_css .= '@media (min-width: 1200px){';
                                    if (!empty($flex_column_items_vertical)) {
                                        $column_css .= '.ui-column-' . $key . '::before{';
                                    } else {
                                        $column_css .= '.ui-column-' . $key . '::before{';
                                    }
                                    $column_css .= 'width: calc(100% - 40px);';
                                    $column_css .= '}';
                                    $column_css .= '}';
                                }
                            } elseif ($custom_column_background === "2") {
                                $column_class .= ' uk-position-relative';

                                // square / circle shape
                                if (($column_options['shape'] === 'square' || $column_options['shape'] === 'circle') && ((!empty($column_options['shape_width']) && !empty($column_options['shape_height'])) || (!empty($column_options['shape_width_pixel']) && !empty($column_options['shape_height_pixel'])))) {
                                    // CSS
                                    $column_css .= '.ui-column-' . $key . '::before{';

                                    $column_css .= 'content: " ";';
                                    $column_css .= 'position: absolute;';

                                    // width & height pixel or %
                                    if (!empty($column_options['shape_width']) && !empty($column_options['shape_height'])) {
                                        $column_css .= 'width: ' . $column_options['shape_width'] . '%;';
                                        $column_css .= 'height: ' . $column_options['shape_height'] . '%;';
                                    } elseif (!empty($column_options['shape_width_pixel']) && !empty($column_options['shape_height_pixel'])) {
                                        $column_css .= 'width: ' . $column_options['shape_width_pixel'] . 'px;';
                                        $column_css .= 'height: ' . $column_options['shape_height_pixel'] . 'px;';
                                    }
                                    // background-color
                                    if (!empty($column_options['shape_color'])) {
                                        $column_css .= 'background-color: ' . $column_options['shape_color'] . ';';
                                    } else {
                                        $column_css .= 'background-color: transparent;';
                                    }
                                    // background-image
                                    if (!empty($column_options['shape_background_image'])) {
                                        $column_css .= 'background-image: url("' . Uri::root() . $column_options['shape_background_image'] . '");';
                                        // image repeat
                                        if ($shape_background_image_repeat === "0") {
                                            $column_css .= 'background-repeat: no-repeat;';
                                        }
                                        // image position
                                        if (!empty($column_options['shape_background_image_position'])) {
                                            $backgroundPosition = '';

                                            if ($column_options['shape_background_image_position'] === 'uk-background-top-left') {
                                                $backgroundPosition = '0 0';
                                            } elseif ($column_options['shape_background_image_position'] === 'uk-background-top-center') {
                                                $backgroundPosition = '50% 0';
                                            } elseif ($column_options['shape_background_image_position'] === 'uk-background-top-right') {
                                                $backgroundPosition = '100% 0';
                                            } elseif ($column_options['shape_background_image_position'] === 'uk-background-center-left') {
                                                $backgroundPosition = '0 50%';
                                            } elseif ($column_options['shape_background_image_position'] === 'uk-background-center-center') {
                                                $backgroundPosition = '50% 50%';
                                            } elseif ($column_options['shape_background_image_position'] === 'uk-background-center-right') {
                                                $backgroundPosition = '100% 50%';
                                            } elseif ($column_options['shape_background_image_position'] === 'uk-background-bottom-left') {
                                                $backgroundPosition = '0 100%';
                                            } elseif ($column_options['shape_background_image_position'] === 'uk-background-bottom-center') {
                                                $backgroundPosition = '50% 100%';
                                            } elseif ($column_options['shape_background_image_position'] === 'uk-background-bottom-right') {
                                                $backgroundPosition = '100% 100%';
                                            }

                                            $column_css .= 'background-position: ' . $backgroundPosition . ';';
                                        }
                                        // image size
                                        if (!empty($column_options['shape_background_image_size'])) {
                                            $column_css .= 'background-size: ' . $column_options['shape_background_image_size'] . ';';
                                        }
                                        // image blend modes
                                        if (!empty($column_options['shape_background_image_blend_modes']) && !empty($column_options['shape_color'])) {
                                            $column_css .= 'background-blend-mode: ' . $column_options['shape_background_image_blend_modes'] . ';';
                                        }
                                        // image attachment
                                        if ($shape_background_image_attachment === "fixed") {
                                            $column_css .= 'background-attachment: fixed;';
                                        }
                                    }
                                    // position
                                    $column_css .= 'top: 0;';
                                    if ($shape_position === 'right') {
                                        $column_css .= 'right: 0;';
                                    } else {
                                        $column_css .= 'left: 0;';
                                    }
                                    // margin #ToDo
                                    if (!$shape_margin_top || !$shape_margin_right || !$shape_margin_bottom || !$shape_margin_left) {
                                        $column_css .= 'margin: ' . $shape_margin_top . ' ' . $shape_margin_right . ' ' . $shape_margin_bottom . ' ' . $shape_margin_left . ';';
                                    }
                                    // border
                                    if ($shape_border && !empty($column_options['shape_border_style']) && !empty($column_options['shape_border_color'])) {
                                        $column_css .= 'border: ' . $shape_border . ' ' . $column_options['shape_border_style'] . ' ' . $column_options['shape_border_color'] . ';';
                                    }
                                    if ($column_options['shape'] === 'circle') {
                                        $column_css .= 'border-radius: 50%;';
                                    }
                                    // transform rotate
                                    if ($shape_transform === 'rotate' && !empty($column_options['shape_transform_rotate'])) {
                                        $column_css .= 'transform: rotate(' . $column_options['shape_transform_rotate'] . 'deg);';
                                        // transform rotate3d
                                    } elseif ($shape_transform === 'rotate3d' && !empty($column_options['shape_transform_rotate']) && !empty($column_options['shape_transform3d_1']) && !empty($column_options['shape_transform3d_2']) && !empty($column_options['shape_transform3d_3'])) {
                                        $column_css .= 'transform: rotate3d(' . $column_options['shape_transform3d_1'] . ', ' . $column_options['shape_transform3d_2'] . ', ' . $column_options['shape_transform3d_3'] . ', ' . $column_options['shape_transform_rotate'] . 'deg);';
                                    } else {
                                        $column_css .= 'transform: unset;';
                                    }
                                    // z-index
                                    if ($shape_position_zindex === "1") {
                                        $column_css .= 'z-index: 1;';
                                    }/* else {
                                                $column_css .= 'z-index: -1;';
                                            }*/
                                    $column_css .= '}';

                                    // triangle shape
                                } elseif ($column_options['shape'] === 'triangle' && !empty($column_options['shape_color'])) {
                                    // CSS
                                    $column_css .= '.ui-column-' . $key . '::before{';
                                    // width & height
                                    $column_css .= 'width: 0;';
                                    $column_css .= 'height: 0;';

                                    // background-color
                                    $column_css .= 'background-color: transparent;';
                                    // position
                                    $column_css .= 'top: 0;';
                                    if ($shape_position === 'right') {
                                        $column_css .= 'right: 0;';
                                    } else {
                                        $column_css .= 'left: 0;';
                                    }
                                    // margin
                                    if (!$shape_margin_top || !$shape_margin_right || !$shape_margin_bottom || !$shape_margin_left) {
                                        $column_css .= 'margin: ' . $shape_margin_top . ' ' . $shape_margin_right . ' ' . $shape_margin_bottom . ' ' . $shape_margin_left . ';';
                                    }
                                    // border (build triangle)
                                    if (!empty($column_options['shape_height_pixel'])) {
                                        $column_css .= 'border-left: ' . $column_options['shape_height_pixel'] / 2 . 'px solid transparent;';
                                        $column_css .= 'border-right: ' . $column_options['shape_height_pixel'] / 2 . 'px solid transparent;';
                                        $column_css .= 'border-bottom: ' . $column_options['shape_height_pixel'] . 'px solid ' . $column_options['shape_color'] . ';';
                                    }
                                    // transform rotate
                                    if ($shape_transform === 'rotate' && !empty($column_options['shape_transform_rotate'])) {
                                        $column_css .= 'transform: rotate(' . $column_options['shape_transform_rotate'] . 'deg);';
                                        // transform rotate3d
                                    } elseif ($shape_transform === 'rotate3d' && !empty($column_options['shape_transform_rotate']) && !empty($column_options['shape_transform3d_1']) && !empty($column_options['shape_transform3d_2']) && !empty($column_options['shape_transform3d_3'])) {
                                        $column_css .= 'transform: rotate3d(' . $column_options['shape_transform3d_1'] . ', ' . $column_options['shape_transform3d_2'] . ', ' . $column_options['shape_transform3d_3'] . ', ' . $column_options['shape_transform_rotate'] . 'deg);';
                                    } else {
                                        $column_css .= 'transform: unset;';
                                    }
                                    // z-index
                                    if ($shape_position_zindex === "1") {
                                        $column_css .= 'z-index: 1;';
                                    }/* else {
                                                $column_css .= 'z-index: -1;';
                                            }*/
                                    $column_css .= '}';
                                }
                            }

                            if (!empty($column_options['color_style'])) {
                                $column_class .= ' ' . $column_options['color_style'];
                            }

                            // Add Inline CSS Background / Shapes
                            if (!empty($column_css)) {
                                $inlineColumnCss = '<style>' . $column_css . '</style>';
                            }

                            if (!empty($column_options['grid_gutter'])) {
                                $column_grid_gutter_class .= ' ' . $column_options['grid_gutter'];
                            }
                            if (!empty($column_options['grid_row_gap'])) {
                                $column_grid_gutter_class .= ' ' . $column_options['grid_row_gap'];
                            }
                            if (!empty($column_options['grid_divider'])) {
                                $column_grid_gutter_class .= ' ' . $column_options['grid_divider'];
                            }

                            $rn             = PageHelper::randomNumber() . $column_index;
                            $GridChildWidth = (!empty($column_options['grid_child_width']) ? ' uk-child-width-' . $column_options['grid_child_width'] . '@m' : ' uk-child-width-1-1');

                            // column html
                            $html .= '<div' . $column_id . ' class="column uk-width-' . $column['grid'] . '@m ui-column-' . $key . $column_class . $flex_column_items_vertical . '">';

                            $html .= '<div class="column-wrap">';

                            $html .= '<div class="column-tools uk-position-absolute uk-position-top-center uk-light">';
                            $html .= '<div uk-grid="" class="uk-grid-small uk-flex-middle">';
                            $html .= '<div class="uk-width-auto">';
                            $html .= '<div uk-grid="" class="uk-grid-small uk-flex-middle">';
                            $html .= '<div class="uk-width-auto">';
                            $html .= '<ul class="uk-iconnav ui-background-secondary">';
                            $html .= '<li title="" tabindex="0" uk-tooltip="' . Text::_('COM_UITHEMEBUILDERLITE_TOGGLE_COLUMN_OPTIONS') . '">';
                            $html .= '<a href="javascript:void(0)" class="btn-column-options-toggle uk-text-emphasis uk-icon-button ui-icon-button" uk-toggle="target: #column-options-toggle-1' . $rn . '">';
                            $html .= '<i class="uk-icon" uk-icon="icon: more-vertical; ratio: .8"></i>';
                            $html .= '</a>';
                            $html .= '</li>';
                            $html .= '</ul>';
                            $html .= '</div>';
                            $html .= '<div id="column-options-toggle-1' . $rn . '" class="column-options-toggle uk-width-auto uk-flex-middle" hidden="">';
                            $html .= '<div uk-grid="" class="uk-grid uk-grid-stack">';
                            $html .= '<div class="uk-width-expand uk-first-column uk-flex-middle">';
                            $html .= '<ul class="uk-iconnav">';
                            $html .= '<li uk-tooltip="' . Text::_('COM_UITHEMEBUILDERLITE_CONFIGURE_COLUMN') . '">';
                            $html .= '<a class="btn-column-config uk-icon-button ui-icon-button" href="javascript:void(0)"><i uk-icon="icon: cog; ratio: .8"></i></a>';
                            $html .= '</li>';
                            $html .= '<li uk-tooltip="' . Text::_('COM_UITHEMEBUILDERLITE_ADD_COMPONENT') . '">';
                            $html .= '<a class="btn-add-component uk-icon-button ui-icon-button" href="javascript:void(0)"><i uk-icon="icon: ui-component; ratio: .8"></i></a>';
                            $html .= '</li>';
                            $html .= '</ul>';
                            $html .= '</div>';
                            $html .= '</div>';
                            $html .= '</div>';
                            $html .= '</div>';
                            $html .= '</div>';
                            $html .= '<div class="uk-width-expand">';
                            $html .= '<div class="uk-flex uk-flex-right">';
                            $html .= '<ul class="uk-iconnav">';
                            $html .= '<li>';
                            $html .= '<i class="uk-drag move-column uk-icon-button ui-icon-button uk-text-emphasis" uk-icon="icon: move; ratio: .6"></i>';
                            $html .= '</li>';
                            $html .= '</ul>';
                            $html .= '</div>';
                            $html .= '</div>';
                            $html .= '</div>';
                            $html .= '</div>';

                            // column title + subtitle html
                            if ((!empty($column_options['title']) || !empty($column_options['subtitle'])) && $title_show === "1") {
                                $titleAndSubtitleClasses = PageHelper::getTitleAndSubtitleClasses($column_options);
                                $title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];
                                $subtitle_class          = ($titleAndSubtitleClasses['subtitle'] === '') ? '' : ' ' . $titleAndSubtitleClasses['subtitle'];

                                if (isset($column_options['heading_alignment']) && !empty($column_options['heading_alignment'])) {
                                    $column_heading_alignment = ' class="uk-padding-small uk-padding-remove-vertical ' . $column_options['heading_alignment'] . '"';
                                }
                                $html .= '<div class="' . trim($column_grid_gutter_class) . '" uk-grid="">';
                                $html .= '<div class="uk-width-1-1">';
                                $html .= '<div' . $column_heading_alignment . '>';
                                if (!empty($column_options['title'])) {
                                    $html .= '<' . $column_options['title_heading'] . ' class="' . trim($title_class) . '">';
                                    $html .= '<span>' . $column_options['title'] . '</span>';
                                    $html .= '</' . $column_options['title_heading'] . '>';
                                }
                                if (!empty($column_options['subtitle'])) {
                                    $html .= '<' . $column_options['subtitle_heading'] . ' class="uk-margin-remove-top ' . trim($subtitle_class) . '">';
                                    $html .= '<span>' . $column_options['subtitle'] . '</span>';
                                    $html .= '</' . $column_options['subtitle_heading'] . '>';
                                }
                                $html .= '</div>';
                                $html .= '</div>';
                                $html .= '</div>';
                            }


                            if ($column_options['masonry_grid'] === "1") {
                                $child_width = '';
                                if (!empty($column_options['masonry_grid_parallax'])) {
                                    $parallax = ' parallax:' . $column_options['masonry_grid_parallax'];
                                } else {
                                    $parallax = '';
                                }
                                if (!empty($column_options['grid_m'])) {
                                    $child_width .= ' uk-child-width-' . $column_options['grid_m'] . '@m';
                                }
                                if (!empty($column_options['grid_l'])) {
                                    $child_width .= ' uk-child-width-' . $column_options['grid_l'] . '@l';
                                }
                                if (!empty($column_options['grid_xl'])) {
                                    $child_width .= ' uk-child-width-' . $column_options['grid_xl'] . '@xl';
                                }
                                $html .= '<div class="ui-column-container uk-child-width-1-1' . $child_width . $column_grid_gutter_class . '" uk-grid="masonry: true;' . $parallax . '">';
                            } else {
                                $html .= '<div class="ui-column-container' . $GridChildWidth . $column_grid_gutter_class . '" uk-grid="" uk-sortable="handle: .uk-drag.component-title; group: sortable-component-group">';
                            }

                            foreach ($column['components'] as $item_index => $component) {
                                $style             = [];
                                $component         = PageHelper::toArray($component);
                                $component_options = PageHelper::escapeHtmlArray($component['options']);
                                $component_folder  = str_replace('_', '-', $component['type']);

                                $component_css_class = 'ui-' . $component_folder . '-svg-bg-' . $key . '-' . $item_index;
                                $component_index     = 'ui-' . $component_folder . '-' . $key . '-' . $column_index . '-' . $item_index;
                                $class               = 'ui-' . $component_folder . ' ' . $component_index;

                                $class .= ' ' . PageHelper::getClasses($component_options);

                                $component_css = '';
                                $inline_css = '';

                                $custom_background             = ($component_options['custom_background'] ?? 0);
                                $background_image_repeat       = ($component_options['background_image_repeat'] ?? 0);
                                $parallax_animation_media      = isset($component_options['parallax_animation_media']) ? 'media:' . $component_options['parallax_animation_media'] . ';' : '';
                                $parallax_animation_viewport   = isset($component_options['parallax_animation_viewport']) ? 'viewport:' . $component_options['parallax_animation_viewport'] . ';' : '';
                                $parallax_animation_background = (!isset($component_options['parallax_animation_background']) || (isset($component_options['parallax_animation_background']) && ($component_options['parallax_animation_background'] === '1'))) ? '1' : '0';
                                $parallax_animation_box        = ($component_options['parallax_animation_box'] ?? 0);
                                $scrollspy_animation           = ($component_options['scrollspy_animation'] ?? 0);
                                $scrollspy_animation_repeat    = (!isset($component_options['scrollspy_animation_repeat']) || (isset($component_options['scrollspy_animation_repeat']) && ($component_options['scrollspy_animation_repeat'] == '1'))) ? '1' : '0';

                                $component_background_image_srcset = ($component_options['background_image_srcset'] ?? 0);
                                $component_srcset                  = '';
                                $srcsets                           = array ();
                                $buildStyle                        = '';

                                $use_svg_custom_mask_size = ($component_options['use_svg_custom_mask_size'] ?? 0);

                                $use_img_transition     = ($component_options['use_img_transition'] ?? 0);
                                $use_overlay_transition = ($component_options['use_overlay_transition'] ?? 0);

                                $component_image_height = (isset($component_options['component_image_height']) && !empty($component_options['component_image_height']) ? $component_options['component_image_height'] : '');

                                $currentDate_component      = Factory::getDate()->format('Y-m-d H:i:s');
                                $get_publish_down_component = ($component_options['publish_down'] ?? null);
                                $get_publish_up_section     = ($component_options['publish_up'] ?? '');

                                $publish_down      = $get_publish_down_component == null ? null : $component_options['publish_down'];
                                $isExpired         = !is_null($publish_down) && strtotime($publish_down) < strtotime($currentDate_component);
                                $isNotPublishedYet = strtotime($get_publish_up_section) > strtotime($currentDate_component);
                                $isUnpublished     = $isNotPublishedYet || $isExpired;

                                $item_index++;

                                $component_show = true;

                                if ($isExpired) {
                                    $component_show = false;
                                } elseif ($isUnpublished) {
                                    $component_show = false;
                                }

                                // Get Component Layouts
                                if (File::exists(JPATH_THEMES . DIRECTORY_SEPARATOR . $app->getTemplate() . DIRECTORY_SEPARATOR . 'html' . DIRECTORY_SEPARATOR . 'layouts' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . $component_folder . DIRECTORY_SEPARATOR . $component['type'] . '.php')) {
                                    $layouts = new FileLayout($component['type'], JPATH_THEMES . DIRECTORY_SEPARATOR . $app->getTemplate() . DIRECTORY_SEPARATOR . 'html' . DIRECTORY_SEPARATOR . 'layouts' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . $component_folder . DIRECTORY_SEPARATOR);
                                } else {
                                    $layouts = new FileLayout($component['type'], JPATH_ROOT . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'layouts' . DIRECTORY_SEPARATOR . $component_folder . DIRECTORY_SEPARATOR);
                                }

                                if (isset($component_options['title']) && !empty($component_options['title'])) {
                                    $c_title = PageHelper::escapeHtml($component_options['title']);
                                } elseif (isset($component_options['admin_label']) && !empty($component_options['admin_label'])) {
                                    $c_title = PageHelper::escapeHtml($component_options['admin_label']);
                                } else {
                                    $c_title = ucwords(str_replace('_', ' ', $component['type']));
                                }

                                // if ( $component_show )
                                // {
                                $html .= '<div>';

                                // Custom ID
                                if (!empty($component_options['id'])) {
                                    $id = ' id="' . $component_options['id'] . '"';
                                } else {
                                    $id = '';
                                }

                                // Parallax Animation
                                $parallax_attr_box = '';

                                // Custom Background
                                if ($custom_background === "1") {
                                    if ((!empty($component_options['background_image'])) || (!empty($component_options['background_image_size']))) {
                                        if (!empty($component_options['background_image'])) {
                                            // Background Srcset
                                            if ($component_background_image_srcset === "1" && !empty($component_options['image_width_srcset'])) {
                                                [$width, $height] = getimagesize(Uri::root() . $component_options['background_image']);
                                                $ex        = '.' . pathinfo($component_options['background_image'], PATHINFO_EXTENSION);
                                                $file_name = 'th_' . pathinfo($component_options['background_image'], PATHINFO_FILENAME);
                                                // ratio
                                                $ratio = round($width / $height * 100);

                                                $typeitem         = str_replace('_', '-', $component['type']);
                                                $thumbnail_folder = 'media/com_uithemebuilderlite/ui-themebuilder-thumb/' . $typeitem;

                                                $tmp_srcset    = explode(',', $component_options['image_width_srcset']);
                                                $merge_srcsets = array_merge($srcsets, $tmp_srcset);
                                                $srcsets       = array_map('trim', $merge_srcsets);
                                                $srcsets       = array_unique($srcsets);

                                                $min_val = min($srcsets);

                                                $component_srcset .= ' data-sizes="';
                                                $component_srcset .= '(min-width:  ' . $min_val . 'px) 90vw, ';
                                                $component_srcset .= '(max-width: ' . $width . 'px) 100vw, ';
                                                $component_srcset .= '(max-aspect-ratio: ' . $width . '/' . $height . ') ' . $ratio . 'vh" ';
                                                $component_srcset .= 'data-srcset="';

                                                foreach ($srcsets as $i => $val) {
                                                    if (is_numeric($val) && $val < 4000) {
                                                        unset($srcsets[$i]);
                                                        $component_srcset .= Uri::root() . $thumbnail_folder . '/' . $file_name . '_' . $val . $ex . ' ' . $val . 'w, ';
                                                    }
                                                }

                                                $component_srcset .= Uri::root() . $component_options['background_image'] . ' ' . $width . 'w" ';
                                                $component_srcset .= 'data-src="' . Uri::root() . $component_options['background_image'] . '"';
                                                $component_srcset .= ' uk-img=""';
                                            } elseif (!empty($component_options['background_image'])) {
                                                $style['background-image'] = Uri::root() . $component_options['background_image'];
                                                $component_srcset          = '';
                                            } else {
                                                $style['background-image'] = 'https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg';
                                                $component_srcset          = '';
                                            }

                                            if ($background_image_repeat === "0") {
                                                $class .= ' uk-background-norepeat';
                                            }

                                            if (!empty($component_options['background_image_size'])) {
                                                $class .= ' ' . $component_options['background_image_size'];
                                            }
                                        }
                                    }
                                    if (!empty($component_options['background_color'])) {
                                        $style['background-color'] = $component_options['background_color'];
                                    }
                                    if (((!empty($component_options['background_image'])) && (!empty($component_options['background_color']))) && !empty($component_options['background_image_blend_modes'])) {
                                        $class .= ' ' . $component_options['background_image_blend_modes'];
                                    }
                                    if ((!empty($component_options['background_image'])) && (!empty($component_options['background_image_attachment']))) {
                                        $class .= ' ' . $component_options['background_image_attachment'];
                                    }
                                    if ((!empty($component_options['background_image'])) && (!empty($component_options['background_image_position']))) {
                                        $class .= ' ' . $component_options['background_image_position'];
                                    }
                                    // SVG Background
                                } elseif ($custom_background === "2") {
                                    if (!empty($component_options['svg_list'])) {
                                        $svg_path                   = Uri::root() . $component_options['svg_list'];
                                        $color_placeholder_1        = $component_options['svg_background_color_fallback'];
                                        $color_placeholder_2        = $component_options['svg_background_color_2'];
                                        $color_placeholder_3        = $component_options['svg_background_color_3'];
                                        $text_placeholder           = $component_options['svg_background_text'];
                                        $text_font_size_placeholder = $component_options['svg_background_text_font_size'] . 'px';
                                        $opacity_placeholder        = $component_options['svg_background_image_opacity'];

                                        $class .= ' ' . $component_css_class . $key;

                                        // CSS output
                                        $component_css .= '.' . $component_css_class . $key . '{';
                                        if (!empty($component_options['svg_background_color_fallback'])) {
                                            $component_css .= 'background: ' . $component_options['svg_background_color_fallback'] . ';';
                                            $component_css .= 'background-color: ' . $component_options['svg_background_color_fallback'] . ';';
                                        }
                                        if (!empty($component_options['svg_background_attachment'])) {
                                            $component_css .= 'background-attachment: ' . $component_options['svg_background_attachment'] . ';';
                                        }
                                        if (!empty($component_options['svg_background_image_size'])) {
                                            $component_css .= 'background-size: ' . $component_options['svg_background_image_size'] . ';';
                                        }
                                        if (!empty($component_options['svg_background_image_repeat'])) {
                                            $component_css .= 'background-repeat: ' . $component_options['svg_background_image_repeat'] . ';';
                                        }
                                        if (!empty($component_options['svg_background_position_x']) && !empty($component_options['svg_background_position_y'])) {
                                            $component_css .= 'background-position: ' . $component_options['svg_background_position_x'] . ' ' . $component_options['svg_background_position_y'] . ';';
                                        }
                                            $component_css .= 'background-image: url("data:image/svg+xml,' . PageHelper::convertSVGtoURI($svg_path, $key, $color_placeholder_1, $color_placeholder_2, $color_placeholder_3, $text_placeholder, $text_font_size_placeholder, $opacity_placeholder) . '");';
                                            $component_css .= '}';

                                            $inline_css = '<style>' . (trim(str_replace(array (
                                                "\r\n",
                                                "\r",
                                                "\n",
                                                '  '
                                            ), '', $component_css))) . '</style>';
                                    }
                                    // Gradient Background
                                } elseif ($custom_background === "3") {
                                    $color1 = ($component_options['gradient_color_1'] ?? '');
                                    $color2 = ($component_options['gradient_color_2'] ?? '');
                                    $color3 = ($component_options['gradient_color_3'] ?? '');

                                    $color1_position = (isset($component_options['gradient_color_1_position']) ? $component_options['gradient_color_1_position'] . '%' : '');
                                    $color2_position = (isset($component_options['gradient_color_2_position']) ? $component_options['gradient_color_2_position'] . '%' : '');
                                    $color3_position = (isset($component_options['gradient_color_3_position']) ? $component_options['gradient_color_3_position'] . '%' : '');

                                    $radial_conical_x_position = (isset($component_options['radial_conical_x_position']) ? $component_options['radial_conical_x_position'] . '%' : '');
                                    $radial_conical_y_position = (isset($component_options['radial_conical_y_position']) ? $component_options['radial_conical_y_position'] . '%' : '');

                                    // linear gradient
                                    if ($component_options['gradient_effect'] === 'linear' && (!empty($color1) || !empty($color2) || !empty($color3))) {
                                        $style['background-color'] = $color1; // Fallback color
                                        // 3 active colors
                                        if (!empty($color1) && !empty($color2) && !empty($color3)) {
                                            $style['background'] = 'linear-gradient(' . $component_options['gradient_angle'] . 'deg, ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ', ' . $color3 . ' ' . $color3_position . ')';
                                            // 2 active colors
                                        } elseif (!empty($color1) && !empty($color2)) {
                                            $style['background'] = 'linear-gradient(' . $component_options['gradient_angle'] . 'deg,' . $color1 . $color1_position . ', ' . $color2 . $color2_position . ')';
                                        }
                                        $style['background-attachment'] = 'scroll';

                                        // radial gradient
                                    } elseif ($component_options['gradient_effect'] === 'radial' && ((!empty($color1) && !empty($color2)) || !empty($color3)) && ($radial_conical_x_position && $radial_conical_y_position)) {
                                        $style['background-color'] = $color1; // Fallback color
                                        // 3 active colors
                                        if (!empty($color1) && !empty($color2) && !empty($color3)) {
                                            $style['background'] = 'radial-gradient(circle at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ', ' . $color3 . ' ' . $color3_position . ')';
                                            // 2 active colors
                                        } elseif (!empty($color1) && !empty($color2)) {
                                            $style['background'] = 'radial-gradient(circle at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ')';
                                        }
                                        $style['background-attachment'] = 'scroll';

                                        // conical gradient
                                    } elseif ($component_options['gradient_effect'] === 'conical' && ((!empty($color1) && !empty($color2)) || !empty($color3)) && ($radial_conical_x_position && $radial_conical_y_position)) {
                                        $style['background-color'] = $color1; // Fallback color
                                        // 3 active colors
                                        if (!empty($color1) && !empty($color2) && !empty($color3)) {
                                            $style['background'] = 'conic-gradient(from ' . $component_options['gradient_angle'] . 'deg at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ', ' . $color3 . ' ' . $color3_position . ')';
                                            // 2 active colors
                                        } elseif (!empty($color1) && !empty($color2)) {
                                            $style['background'] = 'conic-gradient(from ' . $component_options['gradient_angle'] . 'deg at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ')';
                                        }
                                    }

                                    // Default Background
                                } elseif (!empty($component_options['background'])) {
                                    $class .= ' ' . $component_options['background'];
                                }

                                // Component inline position style
                                if (!empty($component_options['component_position'])) {
                                    $class .= ' ' . $component_options['component_position'];
                                    // Left
                                    if (!empty($component_options['component_position_left'])) {
                                        $style['left'] = $component_options['component_position_left'];
                                    }
                                    // Right
                                    if (!empty($component_options['component_position_right'])) {
                                        $style['right'] = $component_options['component_position_right'];
                                    }
                                    // Top
                                    if (!empty($component_options['component_position_top'])) {
                                        $style['top'] = $component_options['component_position_top'];
                                    }
                                    // Bottom
                                    if (!empty($component_options['component_position_bottom'])) {
                                        $style['bottom'] = $component_options['component_position_bottom'];
                                    }
                                    // z-index
                                    if (!empty($component_options['component_position_zindex'])) {
                                        $style['z-index'] = $component_options['component_position_zindex'];
                                    }
                                }
                                // set height in px or % (Image Pro)
                                if ($component_image_height) {
                                    $style['height'] = $component_options['component_image_height'];
                                }
                                // Module Style
                                if (!empty($style)) {
                                    $buildStyle = PageHelper::buildStyle($style);
                                }

                                $html .= '<div id="ui-component"' . $scrollspy_animation_attr . $parallax_attr_box . '>';

                                $html .= '<div class="ui-component-container uk-position-relative">';

                                $html .= '<div class="component-tools uk-position-absolute uk-position-bottom-center uk-light">';
                                    $html .= '<div uk-grid="" class="uk-grid-small uk-flex-middle">';
                                        $html .= '<div class="uk-width-auto">';
                                            $html .= '<div uk-grid="" class="uk-grid-small uk-flex-middle">';
                                                $html .= '<div class="uk-width-auto">';
                                                    $html .= '<ul class="uk-iconnav ui-background-secondary">';
                                                        $html .= '<li title="" tabindex="0" uk-tooltip="' . Text::_('COM_UITHEMEBUILDERLITE_TOGGLE_COMPONENT_OPTIONS') . '">';
                                                            $html .= '<a href="javascript:void(0)" class="btn-component-options-toggle uk-text-emphasis uk-icon-button ui-icon-button" onclick="return false;" uk-toggle="target: #component-options-toggle-1' . $rn . $item_index . '">';
                                                                $html .= '<i class="uk-icon" uk-icon="icon: more-vertical; ratio: .8"></i>';
                                                            $html .= '</a>';
                                                        $html .= '</li>';
                                                    $html .= '</ul>';
                                                $html .= '</div>';
                                                $html .= '<div id="component-options-toggle-1' . $rn . $item_index . '" class="component-options-toggle uk-width-auto uk-flex-middle" hidden="">';
                                                    $html .= '<div uk-grid="">';
                                                        $html .= '<div class="uk-width-expand">';
                                                            $html .= '<ul class="uk-iconnav">';
                                                                $html .= '<li><a class="btn-edit-component uk-icon-button ui-icon-button" href="javascript:void(0)" onclick="return false;" uk-tooltip="' . Text::_('COM_UITHEMEBUILDERLITE_EDIT_ELEMENT') . '"><i uk-icon="icon: pencil; ratio: .8"></i></a></li>';
                                                                $html .= '<li><a class="btn-duplicate-component uk-icon-button ui-icon-button" href="javascript:void(0)" onclick="return false;" uk-tooltip="' . Text::_('COM_UITHEMEBUILDERLITE_DUPLICATE_ELEMENT') . '"><i uk-icon="icon: copy; ratio: .8"></i></a></li>';
                                                                $html .= '<li><a class="btn-delete-component uk-icon-button ui-icon-button" href="javascript:void(0)" onclick="return false;" uk-tooltip="' . Text::_('COM_UITHEMEBUILDERLITE_REMOVE_ELEMENT') . '"><i uk-icon="icon: trash; ratio: .8"></i></a></li>';
                                                            $html .= '</ul>';
                                                        $html .= '</div>';
                                                    $html .= '</div>';
                                                $html .= '</div>';
                                            $html .= '</div>';
                                        $html .= '</div>';

                                        $html .= '<div class="uk-width-expand">';
                                            $html .= '<div class="uk-flex uk-flex-right">';
                                                $html .= '<span class="uk-text-muted uk-drag component-title uk-text-small uk-text-truncate move-component uk-overlay uk-overlay-primary uk-padding-small uk-padding-remove-vertical ">';
                                                    $html .= $c_title;
                                                $html .= '</span>';
                                            $html .= '</div>';
                                        $html .= '</div>';
                                    $html .= '</div>';
                                $html .= '</div>';

                                $html .= '<div class="ui-component-content ' . trim($class) . '" ' . $buildStyle . $component_srcset . '>';
                                    $html .= $layouts->render($component);
                                    $html .= $inline_css;
                                $html .= '</div>';

                                $html .= '<div class="component-options uk-hidden"></div>';
                                $html .= '<input class="json-component" type="hidden" value="' . $this->escape(json_encode(PageHelper::toArray($component), JSON_THROW_ON_ERROR)) . '">';

                                $html .= '</div>';

                                $html .= '</div>';

                                $html .= '</div>';
                                // }
                            }

                            $html .= '</div>';

                            /* if (!empty($flex_column_items_vertical))
                                                    {
                                                        $html .= '</div>';
                                                        $html .= '</div>';
                                                    } */

                            $html .= '<div class="column-options uk-hidden"></div>';
                            $html .= '<input class="json-column" type="hidden" value="' . $this->escape(json_encode($column, JSON_THROW_ON_ERROR)) . '">';
                            if ($inlineColumnCss) {
                                $html .= $inlineColumnCss;
                            }
                            $html .= '</div>';
                            // $html .= '</div>';
                            $html .= '</div>';
                        }

                        $html .= '</div>';
                        // END column html

                        // }

                        if (($section_full_width === "0") && !empty($section_options['container_width'])) {
                            $html .= '</div>';
                        }

                        $html .= '<div class="section-options-preview uk-hidden"></div>';
                        $html .= '<input class="json-section" type="hidden" value="' . $this->escape(json_encode($json_section, JSON_THROW_ON_ERROR)) . '">';

                        $html .= $inline_css_section;

                        $html .= '</' . $section_options['html_tag'] . '>';

                        echo $html; ?>
                    </div> <?php
                } ?>
            </div>
            <?php
        } else { ?>
            <div
                class="ui-themebuilder-wrapper ui-section-content uk-section uk-section-default uk-padding-remove-vertical"
                uk-sortable="handle: .uk-h4.uk-drag"></div>
            <?php
        } ?>

        <!-- Add Section (clone) -->
        <div id="section" class="section-container uk-hidden">

            <div class="section-tools uk-position-absolute uk-position-top-left uk-width-1-1">
                <div uk-grid="" class="uk-grid-small">
                    <div class="uk-width-auto">
                        <div class="uk-panel">
                            <ul class="uk-iconnav">
                                <li class="uk-drag move-section"
                                    uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_SECTION'); ?>">
                                    <i class="uk-text-emphasis uk-margin-small-top uk-margin-small-left uk-icon-button uk-drag"
                                       uk-icon="move"></i>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="uk-width-expand">
                        <div class="uk-flex uk-flex-right">
                            <div class="uk-panel uk-overlay uk-overlay-primary uk-padding-small">
                                <div uk-grid="" class="uk-grid-small uk-flex-middle">
                                    <?php $rn = PageHelper::randomNumber(); ?>
                                    <div id="section-options-toggle-0<?php echo $rn; ?>"
                                         class="section-options-toggle uk-width-expand" hidden="">
                                        <div uk-grid="" class="uk-flex-middle">

                                            <div class="uk-width-expand">
                                                <ul class="uk-iconnav section-actions">

                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_SAVE_SECTION'); ?>">
                                                        <a class="btn-save-section" href="javascript:void(0)"><i
                                                                uk-icon="ui-save"></i></a></li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_ADD_ROW'); ?>">
                                                        <a class="btn-add-section" href="javascript:void(0)"><i
                                                                uk-icon="ui-section"></i></a></li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_DUPLICATE_ROW'); ?>">
                                                        <a class="btn-duplicate-section" href="javascript:void(0)"><i
                                                                uk-icon="copy"></i></a></li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_CONFIGURE_ROW'); ?>">
                                                        <a class="btn-config-section" href="javascript:void(0)"><i
                                                                uk-icon="cog"></i></a></li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_DELETE_ROW'); ?>">
                                                        <a class="btn-delete-section" href="javascript:void(0)"><i
                                                                uk-icon="trash"></i></a></li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_ADD_MANAGE_COLUMNS'); ?>">
                                                        <a class="btn-manage-columns btn-manage-columns<?php echo $rn; ?> uk-text-muted"
                                                           href="javascript:void(0)"><i uk-icon="ui-columns"></i></a>
                                                        <div id="manage-columns-dropdown<?php echo $rn; ?>"
                                                             class="manage-columns-dropdown manage-columns-dropdown<?php echo $rn; ?> uk-background-secondary uk-light"
                                                             uk-dropdown="mode: click; pos: top-right; toggle: .btn-manage-columns<?php echo $rn; ?>">
                                                            <div class="uk-width-xlarge">
                                                                <div class="uk-margin-small uk-height-max-medium"
                                                                     uk-overflow-auto>
                                                                    <ul class="uk-grid-medium uk-child-width-1-1@s uk-child-width-1-4@m uk-flex-center uk-margin grids"
                                                                        uk-grid="">
                                                                        <li>
                                                                            <div
                                                                                class="grid-default active-grid uk-background-primary uk-light"
                                                                                data-grid="1-1"
                                                                                uk-tooltip="1-1 (whole)">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#whole"
                                                                                    uk-svg alt="1-1 (whole)">
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div class="grid-default"
                                                                                 data-grid="1-2;1-2"
                                                                                 uk-tooltip="1-2;1-2 (halves)">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#halves"
                                                                                    uk-svg alt="1-2;1-2 (halves)">
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div class="grid-default"
                                                                                 data-grid="1-3;1-3;1-3"
                                                                                 uk-tooltip="1-3;1-3;1-3 (thirds)">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#thirds"
                                                                                    uk-svg alt="1-3;1-3;1-3 (thirds)">
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div class="grid-default"
                                                                                 data-grid="1-4;1-4;1-4;1-4"
                                                                                 uk-tooltip="1-4;1-4;1-4;1-4 (quarters)">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#quarters"
                                                                                    uk-svg
                                                                                    alt="1-4;1-4;1-4;1-4 (quarters)">
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div class="grid-default"
                                                                                 data-grid="auto;expand;1-1"
                                                                                 uk-tooltip="auto;expand;1-1">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#auto-expand-whole"
                                                                                    uk-svg alt="auto;expand;1-1">
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div class="grid-default"
                                                                                 data-grid="expand;1-2;expand"
                                                                                 uk-tooltip="expand;1-2;expand">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#expand-1-2-expand"
                                                                                    uk-svg alt="expand;1-2;expand">
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div class="grid-default"
                                                                                 data-grid="expand;2-3"
                                                                                 uk-tooltip="expand;2-3">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#expand-2-3"
                                                                                    uk-svg alt="expand;2-3">
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div class="grid-default"
                                                                                 data-grid="expand;large;expand"
                                                                                 uk-tooltip="expand;large;expand">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#expand-large-expand"
                                                                                    uk-svg alt="expand;large;expand">
                                                                            </div>
                                                                        </li>
                                                                        <li class="uk-hidden">
                                                                            <div class="grid-default custom-grid"
                                                                                 data-grid="1-1">
                                                                            </div>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                                <div class="uk-padding-small">
                                                                    <div class="uk-flex uk-flex-center">
                                                                        <div class="uk-flex uk-flex-middle">
                                                                            <span
                                                                                class="uk-text-small uk-margin-small-right uk-text-muted"><?php echo Text::_('COM_UITHEMEBUILDERLITE_CUSTOM_GRID'); ?></span>
                                                                            <div class="uk-width-expand">
                                                                                <div class="uk-inline">
                                                                                    <a class="uk-form-icon uk-form-icon-flip btn-generate-layout"
                                                                                       href="javascript:void(0)"
                                                                                       uk-icon="ui-columns"></a>
                                                                                    <input type="text" class="uk-input"
                                                                                           name="custom_layout"
                                                                                           placeholder="expand;2-3"
                                                                                           value="">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_TOGGLE_SECTION'); ?>">
                                                        <a class="btn-toggle-section"
                                                           href="#ui-section-1<?php echo $rn; ?>"
                                                           uk-toggle="animation: uk-animation-slide-left, uk-animation-fade;"><i
                                                                uk-icon="chevron-down"></i></a></li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_DISABLE_SECTION'); ?>">
                                                        <a class="btn-disable-section" href="javascript:void(0)"
                                                           uk-icon="unlock"></a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="uk-width-auto">
                                        <ul class="uk-iconnav">
                                            <li title="" tabindex="0" uk-tooltip="Toggle Section Options">
                                                <a class="btn-toggle-section-options" href="javascript:void(0)"
                                                   uk-toggle="target: #section-options-toggle-0<?php echo $rn; ?>">
                                                    <i uk-icon="more-vertical"></i>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <section id="ui-section-1<?php echo $rn; ?>" class="ui-section uk-section uk-position-relative">
                <div class="ui-columns" uk-grid=""
                     uk-sortable="handle: .uk-drag.move-column; group: sortable-column-group-0">
                    <div class="column uk-width-1-1">
                        <div class="column-wrap">
                            <div class="column-tools uk-position-absolute uk-position-top-center uk-light">
                                <div uk-grid="" class="uk-grid-small uk-flex-middle">
                                    <div class="uk-width-auto">
                                        <div uk-grid="" class="uk-grid-small uk-flex-middle">
                                            <div class="uk-width-auto">
                                                <ul class="uk-iconnav ui-background-secondary">
                                                    <li title="" tabindex="0"
                                                        uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_TOGGLE_COLUMN_OPTIONS'); ?>">
                                                        <a href="javascript:void(0)"
                                                           class="btn-column-options-toggle uk-icon-button ui-icon-button"
                                                           uk-toggle="target: #column-options-toggle-0<?php echo $rn; ?>">
                                                            <i class="uk-icon"
                                                               uk-icon="icon: more-vertical; ratio: .8"></i>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div id="column-options-toggle-0<?php echo $rn; ?>"
                                                 class="column-options-toggle uk-width-auto uk-flex-middle" hidden="">
                                                <div uk-grid="" class="uk-grid uk-grid-stack">
                                                    <div class="uk-width-expand uk-first-column uk-flex-middle ">
                                                        <ul class="uk-iconnav">
                                                            <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_CONFIGURE_COLUMN'); ?>">
                                                                <a class="btn-column-config uk-icon-button ui-icon-button"
                                                                   href="javascript:void(0)"><i
                                                                        uk-icon="icon: cog; ratio: .8"></i></a>
                                                            </li>
                                                            <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_ADD_COMPONENT'); ?>">
                                                                <a class="btn-add-component uk-icon-button ui-icon-button"
                                                                   href="javascript:void(0)"><i
                                                                        uk-icon="icon: ui-component; ratio: .8"></i></a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="uk-width-expand">
                                        <div class="uk-flex uk-flex-right">
                                            <ul class="uk-iconnav">
                                                <li>
                                                    <i class="uk-drag move-column uk-icon-button ui-icon-button uk-text-emphasis"
                                                       uk-icon="icon: move; ratio: .6"></i>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="ui-column-container uk-child-width-1-1" uk-grid=""
                                 uk-sortable="handle: .uk-drag.component-title; group: sortable-component-group">

                            </div>

                            <div class="column-options uk-hidden"></div>
                            <input class="json-column" type="hidden"
                                   value="<?php echo $this->escape(json_encode($this->column_config, JSON_THROW_ON_ERROR)); ?>">
                        </div>
                    </div>
                </div>

                <div class="section-options-preview uk-hidden"></div>
                <input class="json-section" type="hidden"
                       value="<?php echo $this->escape(json_encode($this->section_config, JSON_THROW_ON_ERROR)); ?>">
            </section>

        </div>

        <!-- Load Modals -->
        <?php echo $this->loadTemplate('options'); ?>

        <input type="hidden" id="form_task" name="task" value="page.apply"/>
        <?php echo HTMLHelper::_('form.token'); ?>

    </form>
    <?php echo LayoutHelper::render('footer'); ?>
</div>
