<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2023 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Administrator\View\Pages;

defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Content\Administrator\Helper\ContentHelper;
use SW\Component\uiThemeBuilderLite\Administrator\Helper\PageHelper;

/**
 * View class for a list of pages.
 *
 * @since  1.0.0
 */
class HtmlView extends BaseHtmlView
{

    protected $items;

    /**
     * Method to display the view.
     *
     * @param   string  $tpl  A template file to load. [optional]
     *
     * @return  void
     *
     * @throws \Exception
     *
     * @since   1.0.0
     */
    public function display($tpl = null): void
    {

        $this->items = $this->get('Items');
        $this->pagination = $this->get('Pagination');
        $this->state = $this->get('State');
        $this->filterForm = $this->get('FilterForm');
        $this->activeFilters = $this->get('ActiveFilters');
        $wa = $this->getDocument()->getWebAssetManager();

        // Load CSS files
//      HTMLHelper::_('stylesheet', 'com_uithemebuilderlite/admin-style.min.css', array('version' => 'auto', 'relative' => true));

        if (count($errors = $this->get('Errors'))) {
            throw new GenericDataException(implode("\n", $errors), 500);
        }
        $this->addToolBar();

        // We do not need to filter by language when multilingual is disabled
        if (!Multilanguage::isEnabled()) {
            unset($this->activeFilters['language']);
            $this->filterForm->removeField('language', 'filter');
        }

        ToolbarHelper::preferences('com_uithemebuilderlite');

//      $js = 'var themebuilder_root="' . Uri::root() . '";';
//      $wa->addInlineScript($js);

        parent::display($tpl);
    }

    /**
     *
     *
     *
     * @since   0.0.1
     */
    protected function addToolBar(): void
    {

        $jToolbar = Toolbar::getInstance();
        $canDo = ContentHelper::getActions('com_uithemebuilderlite');
        // Title
        ToolbarHelper::title('<strong>' . Text::_('COM_UITHEMEBUILDERLITE') . '</strong>: ' . Text::_('COM_UITHEMEBUILDERLITE_PAGES'));
        // Help
        ToolbarHelper::help(null, false, 'https://www.ui-themebuilder.com/documentation.html');
        // New page button
        if ($canDo->get('core.create')) {
            ToolbarHelper::addNew('page.add');
        }

        // publish and unpublished button
        if ($canDo->get('core.edit.state')) {
            $dropdown = $jToolbar->dropdownButton('status-group')
                ->text('JTOOLBAR_CHANGE_STATUS')
                ->toggleSplit(false)
                ->icon('fas fa-ellipsis-h')
                ->buttonClass('btn btn-action')
                ->listCheck(true);

            $childBar = $dropdown->getChildToolbar();
            $childBar->checkin('pages.checkin')->listCheck(true);
            $childBar->publish('pages.publish')->listCheck(true);
            $childBar->unpublish('pages.unpublish')->listCheck(true);

            $childBar->standardButton('featured')
                ->text('JFEATURE')
                ->task('pages.featured')
                ->listCheck(true);
            $childBar->standardButton('unfeatured')
                ->text('JUNFEATURE')
                ->task('pages.unfeatured')
                ->listCheck(true);

            $childBar->archive('pages.archive')->listCheck(true);

            if ($this->state->get('filter.state') != -2) {
                $childBar->trash('pages.trash')->listCheck(true);
            }
        }

        // Delete and Trash button
        if ($this->state->get('filter.published') == -2 && $canDo->get('core.delete')) {
            ToolbarHelper::deleteList('', 'pages.delete', 'JTOOLBAR_EMPTY_TRASH');
        } /* else if ($canDo->get('core.edit.state')) {
            ToolbarHelper::trash('pages.trash');
        } */

        // Page Import Button
        if (PageHelper::getProParams('import')) {
            $importButton = '<joomla-toolbar-button id="toolbar-import-pro"><button class="btn btn-small btn-info" uk-toggle="target: #import-modal" type="button"><span class="icon-forward-2 uk-margin-small-right"></span>' . Text::_('COM_UITHEMEBUILDERLITE_IMPORT_PAGE') . '</button></joomla-toolbar-button>';
            $jToolbar->appendButton('Custom', $importButton, 'import');

            if ($importClass = PageHelper::getProParams('import')) {
                $importClass->loadImportModal();
            }
        } else {
            $importButton = '<joomla-toolbar-button id="toolbar-import-lite"><button class="btn btn-small btn-info" uk-toggle="target: #import-modal-noPro" type="button"><span class="icon-forward-2 uk-margin-small-right"></span>' . Text::_('COM_UITHEMEBUILDERLITE_IMPORT_PAGE') . '</button></joomla-toolbar-button>';
            $importButton .= '<div id="import-modal-noPro" class="uk-flex-top" uk-modal>
				<div class="uk-modal-dialog uk-margin-auto-vertical">
					<button class="uk-modal-close-default" type="button" uk-close></button>
					<div class="uk-modal-header">
						<h2 class="uk-modal-title">' . Text::_('COM_UITHEMEBUILDERLITE_IMPORT_PAGE') . '</h2>
					</div>
					<div class="uk-modal-body uk-flex uk-flex-center">
						<div class="uk-margin" uk-margin>
							' . Text::_('COM_UITHEMEBUILDERLITE_PRO') . '
						</div>
					</div>
				</div>
			</div>';

            $jToolbar->appendButton('Custom', $importButton, 'import');
        }
    }

    /**
     *
     * @return array
     *
     * @since   1.0.0
     */
    protected function getSortFields(): array
    {
        return array(
            'p.published' => Text::_('JSTATUS'),
            'p.title' => Text::_('JGLOBAL_TITLE'),
            'access_level' => Text::_('JGRID_HEADING_ACCESS'),
            'author_name' => Text::_('JAUTHOR'),
            'language' => Text::_('JGRID_HEADING_LANGUAGE'),
            'p.created' => Text::_('JDATE'),
            'p.id' => Text::_('JGRID_HEADING_ID')
        );
    }
}
