<?php
/**
 * @package        ui/Theme-Builder Lite
 * @author         Stephan W.
 * @author         url    https://www.ui-themebuilder.com/
 * @copyright      Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer      Stephan Wittling - https://www.ui-themebuilder.com/
 *                ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *                but WITHOUT ANY WARRANTY; without even the implied warranty of
 *                MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *                See the GNU General Public License for more details.
 * @license        http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Administrator\Field;

// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

class TagListField extends ListField
{

    /**
     * The form field type.
     *
     * @var     string
     *
     * @since   v1.0.0
     */
    protected $type = 'TagList';

    /**
     * Method to get the field input markup.
     *
     * @return  string  The field input markup.
     *
     * @since   v1.0.0
     */
    public function getInput(): string
    {
        $html = array();
        $attr = !empty($this->class) ? ' class="' . $this->class . '"' : '';
        $article_tags = (array)$this->getArticleTags();
        $html[] = HTMLHelper::_('select.genericlist', $article_tags, $this->name, trim($attr), 'value', 'text', $this->value, $this->id);
        return implode($html);
    }

    // Get article tags list
    protected function getArticleTags(): array
    {
        $db    = Factory::getContainer()->get('DatabaseDriver');
        $query = $db->getQuery(true)->select('DISTINCT a.id, a.title, a.level, a.published, a.lft, a.parent_id');
        $subQuery = $db->getQuery(true)->select('id,title,level,published,parent_id,lft,rgt')->from('#__tags')->where($db->quoteName('published') . ' = ' . $db->quote(1));
        $query->from('(' . $subQuery->__toString() . ') AS a')->join('LEFT', $db->quoteName('#__tags') . ' AS b ON a.lft > b.lft AND a.rgt < b.rgt');
        $query->where($db->quoteName('a.level') . ' != ' . $db->quote(0));
        $query->order('a.lft ASC');
        $db->setQuery($query);
        $tags = $db->loadObjectList();
        $article_tags = array(
            0 => array(
                'value' => '',
                'text' => Text::_('COM_UITHEMEBUILDERLITE_SELECT_TAG')
            )
        );
        if (count((array)$tags)) {
            foreach ($tags as $tag) {
                $parent_tag = '';
                if ($tag->level > 1) {
                    $parent_tag = $this->getParentTag($tag->parent_id)->title . '/';
                }
                $article_tags[$tag->id] = $parent_tag . $tag->title;
            }
        }
        return $article_tags;
    }

    // get parent tag id

    /**
     * @param   string  $parentid
     *
     * @return mixed|null
     *
     * @since v1.0.0
     */
    public function getParentTag(string $parentid = ''): mixed
    {
        $db    = Factory::getContainer()->get('DatabaseDriver');
        $query = $db->getQuery(true);
        $query->select(array(
            'a.id',
            'a.title'
        ));
        $query->from($db->quoteName('#__tags', 'a'));
        $query->where($db->quoteName('id') . " = " . $db->quote($parentid));
        $query->where($db->quoteName('published') . " = 1");
        $db->setQuery($query);

        return $db->loadObject();
    }
}
