<?php
/**
 * @package        ui/Theme-Builder Lite
 * @author         Stephan W.
 * @author         url    https://www.ui-themebuilder.com/
 * @copyright      Copyright (C) 2023 ui-themebuilder.com, All rights reserved.
 * @developer      Stephan Wittling - https://www.ui-themebuilder.com/
 *                ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *                but WITHOUT ANY WARRANTY; without even the implied warranty of
 *                MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *                See the GNU General Public License for more details.
 * @license        http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Administrator\Field;

// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;

class IconsListField extends FormField
{

    /**
     * The form field type.
     *
     * @var     string
     *
     * @since   v1.0.0
     */
    protected $type = 'IconsList';

    /**
     * Method to get the field input markup.
     *
     * @return  string  The field input markup.
     *
     * @throws \Exception
     * @since   v1.0.0
     */
    public function getInput(): string
    {

        $html = '';
        $id_name = str_replace('_', '-', $this->name);
        $id = $id_name . '-' . random_int(1001, 9999);
        !empty($this->class) ? $this->class = ' ' . $this->class : $this->class = '';

        // Build field HTML
        $html .= '<div class="ui-icons-list uk-margin-remove">';

        $html .= '<button class="uk-button uk-button-secondary" type="button" id="GetIconPicker' . $id . '" data-iconpicker-input="input#IconInput-' . $id . '" data-iconpicker-preview="i#IconPreview-' . $id . '">';
        $html .= '<span class="selected">';
        if ($this->default) {
            $html .= '<i id="IconPreview-' . $id . '" class="' . $this->default . '"></i>';
            $html .= '<span>' . $this->default . '</span>';
        } else {
            $html .= '<i id="IconPreview-' . $id . '" class="no-icon"></i>';
            $html .= '<span>' . Text::_('COM_UITHEMEBUILDERLITE_NO_ICON') . '</span>';
        }
        $html .= '</span>';
        $html .= '</button>';

        $html .= '<input id="IconInput-' . $id . '"  type="hidden" name="' . $this->name . '" class="iconslist' . $this->class . '" value="' . $this->default . '">';

        $html .= '</div>';

        return $html;
    }
}
