<?php
/**
 * @package        ui/Theme-Builder Lite
 * @author         Stephan W.
 * @author         url    https://www.ui-themebuilder.com/
 * @copyright      Copyright (C) 2023 ui-themebuilder.com, All rights reserved.
 * @developer      Stephan Wittling - https://www.ui-themebuilder.com/
 *                ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *                but WITHOUT ANY WARRANTY; without even the implied warranty of
 *                MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *                See the GNU General Public License for more details.
 * @license        http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Administrator\Field;

// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;

class GradientPreviewField extends FormField
{

    /**
     * The form field type.
     *
     * @var     string
     *
     * @since   v1.0.0
     */
    protected $type = 'GradientPreview';

    /**
     * Method to get the field input markup.
     *
     * @return  string  The field input markup.
     *
     * @since   v1.0.0
     */
    public function getInput(): string
    {
        return '';
    }

    /**
     * Method to get the field label markup.
     *
     * @return  string  The field label markup.
     *
     * @throws \Exception
     * @since   v1.0.0
     */
    public function getLabel(): string
    {
        $html = array();
        $class = !empty($this->class) ? (' class="' . $this->class . '"') : '';
        $html[] = '<div class="uk-margin">';
        $html[] = '<h5 class="uk-h6 uk-heading-line uk-text-muted">';

        $label = '';

        // Get the label text from the XML element, defaulting to the element name.
        $text = $this->element['label'] ? (string)$this->element['label'] : (string)$this->element['name'];
        $text = $this->translateLabel ? Text::_($text) : $text;

        // Build the class for the label.
        $class = $this->required ? $class . ' required' : $class;

        // Add the opening label tag and main attributes attributes.
        $label .= '<span ' . $class;

        // If a description is specified, use it to build a tooltip.
        if (!empty($this->description)) {
            $label .= ' uk-tooltip="title:' . htmlspecialchars(trim($text, ':'), ENT_COMPAT, 'UTF-8') . '; pos: bottom"';

            if (Factory::getApplication()->getLanguage()->isRtl()) {
                $label .= ' data-placement="left"';
            }
        }

        // Add the label text and closing tag.
        $label .= '>' . $text . '</span></h5>';
        $html[] = $label;

        $html[] = '<div class="uk-container">';
        $html[] = '<div class="ui-gradient-preview uk-box-shadow-medium uk-panel" style="position: relative; width: 100%; height: 60px; border-radius: 1px;"></div>';
        $html[] = '</div>';
        $html[] = '</div>';

        return implode('', $html);
    }
}
