CREATE TABLE IF NOT EXISTS `#__uithemebuilderlite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `page_cache` tinyint(3) NOT NULL DEFAULT '1',
  `catid` int(11) NOT NULL DEFAULT '0',
  `extension` varchar(255) NOT NULL DEFAULT 'com_uithemebuilderlite',
  `content` mediumtext NOT NULL,
  `version` varchar(4000) NOT NULL DEFAULT '',
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Set if page is featured.',
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `disable_og_url` tinyint(3) NOT NULL DEFAULT '1',
  `open_graph_title` varchar(255) NOT NULL,
  `open_graph_image` varchar(255) NOT NULL,
  `open_graph_image_alt` varchar(255) NOT NULL,
  `open_graph_content_type` varchar(255) NOT NULL,
  `open_graph_description` varchar(255) NOT NULL,
  `twitter_card_site` varchar(255) NOT NULL,
  `twitter_card_image` varchar(255) NOT NULL,
  `twitter_card_image_alt` varchar(255) NOT NULL,
  `twitter_card_description` varchar(255) NOT NULL,
  `twitter_card_content_type` varchar(255) NOT NULL, 
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `robots` text NOT NULL,
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `publish_up` datetime NOT NULL,
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `access` int(10) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `checked_out` int(10) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `hits` bigint(20) NOT NULL DEFAULT '0',
  `css` longtext NOT NULL,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


INSERT INTO `#__content_types` (`type_title`, `type_alias`, `rules`, `field_mappings`, `table`, `content_history_options`) 
VALUES
('uiTheme-Builder Pro', 'com_uithemebuilderlite.page', '', '',
'{"special": {"dbtable": "#__uithemebuilderlite", "key": "id", "type": "uiTheme-Builder Pro", "prefix": "SW\\Component\\uiThemeBuilderLite\\Administrator\\Table\\", "config": "array()"},
"common": {"dbtable": "#__ucm_content", "key": "ucm_id", "type": "Corecontent", "prefix": "JTable", "config": "array()" }
}',
'{"formFile":"administrator\/components\/com_uithemebuilderlite\/forms\/page.xml", 
"hideFields":["created_by","modified","content","id","modified_by","hits","version"], 
"ignoreChanges":["published", "checked_out", "checked_out_time", "hits","version"], 
"convertToInt":["publish_up", "publish_down"], 
"displayLookup":[
{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, 
{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},
{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},
{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]
}');