<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Factory;

extract($displayData);

/**
 * Layout variables
 * -----------------
 *
 * @var   array  $options     Optional parameters
 * @var   string $name        The id of the input this label is for
 * @var   string $label       The html code for the label
 * @var   string $input       The input field html code
 * @var   string $description An optional description to use in a tooltip
 */

if (!empty($options['showonEnabled'])) {
    /** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
    $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
    $wa->useScript('showon');
}

$class = empty($options['class']) ? '' : ' class="' . $options['class'] . '"';
$rel = empty($options['rel']) ? '' : ' ' . $options['rel'];
$id = $name . '-desc';
$hide = empty($options['hiddenLabel']) ? '' : ' sr-only';
$hideDescription = empty($options['hiddenDescription']) ? false : $options['hiddenDescription'];
?>
<div<?php echo $class; ?><?php echo $rel; ?>>
    <?php echo $label; ?>
    <div class="uk-form-controls">
        <?php echo $input; ?>
    </div>
</div>
