<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2023 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
\defined('_JEXEC') or die;


use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

extract($displayData, EXTR_REFS);

/**
 * Layout variables
 * -----------------
 *
 * @var  string  $asset          The asset text
 * @var  string  $authorField    The label text
 * @var  integer $authorId       The author id
 * @var  string  $class          The class text
 * @var  boolean $disabled       True if field is disabled
 * @var  string  $folder         The folder text
 * @var  string  $id             The label text
 * @var  string  $link           The link text
 * @var  string  $name           The name text
 * @var  string  $preview        The preview image relative path
 * @var  integer $previewHeight  The image preview height
 * @var  integer $previewWidth   The image preview width
 * @var  string  $onchange       The onchange text
 * @var  boolean $readonly       True if field is readonly
 * @var  integer $size           The size text
 * @var  string  $value          The value text
 * @var  string  $src            The path and filename of the image
 * @var  string  $dataAttribute  Miscellaneous data attributes preprocessed for HTML output
 * @var  array   $dataAttributes Miscellaneous data attribute for eg, data-*
 */
$img_style = '';
$attr = '';

// Initialize some field attributes.
$attr .= !empty($class) ? ' class="form-control field-media-input input-media ' . $class . '"' : ' class="form-control field-media-input input-media"';
$attr .= !empty($size) ? ' size="' . $size . '"' : '';
$attr .= $dataAttribute;

// Initialize JavaScript field attributes.
$attr .= !empty($onchange) ? ' onchange="' . $onchange . '"' : '';

switch ($preview) {
    case 'no': // Deprecated parameter value
    case 'false':
    case 'none':
        $showPreview = false;
        break;
    case 'yes': // Deprecated parameter value
    case 'true':
    case 'show':
    case 'tooltip':
    default:
        $showPreview = true;
        break;
}

// Pre fill the contents of the popover
if ($showPreview) {
    if ($value && file_exists(JPATH_ROOT . '/' . $value)) {
        $src = Uri::root() . $value;
    } else {
        $src = '';
    }
    $width = $previewWidth;
    $height = $previewHeight;
    $style = ($width > 0) ? 'max-width:' . $width . 'px;' : '';
    $style .= ($height > 0) ? 'max-height:' . $height . 'px;' : '';

    $imgAttr = array(
        'id' => $id . '_preview',
        'class' => 'media-preview',
        'style' => $style,
    );

    $img = HTMLHelper::_('image', $src, Text::_('JLIB_FORM_MEDIA_PREVIEW_ALT'), $imgAttr);

    $previewImg = sprintf("<div id=\"%s_preview_img\">%s</div>", $id, $img);
    $previewImgEmpty = sprintf("<div id=\"%s_preview_empty\"%s>%s</div>", $id, $src ? ' class="hidden"' : '', Text::_('JLIB_FORM_MEDIA_PREVIEW_EMPTY'));

    $showPreview = 'static';
}

// The url for the modal
$url = ($readonly ? ''
    : ($link ?: 'index.php?option=com_media&view=media&tmpl=component&mediatypes=' . $mediaTypes
        . '&asset=' . $asset . '&author=' . $authorId)
    . '&fieldid={field-media-id}&path=' . $folder);

// Correctly route the url to ensure it's correctly using sef modes and subfolders
$url = Route::_($url);

Text::script('JFIELD_MEDIA_LAZY_LABEL');
Text::script('JFIELD_MEDIA_ALT_LABEL');
Text::script('JFIELD_MEDIA_ALT_CHECK_LABEL');
Text::script('JFIELD_MEDIA_ALT_CHECK_DESC_LABEL');
Text::script('JFIELD_MEDIA_CLASS_LABEL');
Text::script('JFIELD_MEDIA_FIGURE_CLASS_LABEL');
Text::script('JFIELD_MEDIA_FIGURE_CAPTION_LABEL');
Text::script('JFIELD_MEDIA_LAZY_LABEL');
Text::script('JFIELD_MEDIA_SUMMARY_LABEL');
Text::script('JFIELD_MEDIA_EMBED_CHECK_DESC_LABEL');
Text::script('JFIELD_MEDIA_DOWNLOAD_CHECK_DESC_LABEL');
Text::script('JFIELD_MEDIA_DOWNLOAD_CHECK_LABEL');
Text::script('JFIELD_MEDIA_EMBED_CHECK_LABEL');
Text::script('JFIELD_MEDIA_WIDTH_LABEL');
Text::script('JFIELD_MEDIA_TITLE_LABEL');
Text::script('JFIELD_MEDIA_HEIGHT_LABEL');
Text::script('JFIELD_MEDIA_UNSUPPORTED');
Text::script('JFIELD_MEDIA_DOWNLOAD_FILE');
Text::script('JLIB_APPLICATION_ERROR_SERVER');
Text::script('JLIB_FORM_MEDIA_PREVIEW_EMPTY', true);

?>
<joomla-field-media class="field-media-wrapper"
                    type="image" <?php // @TODO add this attribute to the field in order to use it for all media types ?>
                    base-path="<?php echo Uri::root(); ?>"
                    root-folder="<?php echo ComponentHelper::getParams('com_media')->get('file_path', 'images'); ?>"
                    url="<?php echo $url; ?>"
>
    <?php // echo $modalHTML; ?>
    <div class="ui-media">
        <div class="ui-media-preview no-height">
            <div class="ui-img-preview uk-height-small uk-background-contain uk-dark"><a
                    class="btn-media-remove uk-position-small uk-position-center-right-out"
                    href="javascript:void(0)"
                    uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_REMOVE_IMAGE'); ?>"><i
                        uk-icon="close"></i></a></div>
        </div>
        <input type="hidden" name="<?php echo $name; ?>" id="<?php echo $id; ?>"
               value="<?php echo htmlspecialchars($value, ENT_COMPAT, 'UTF-8'); ?>"
               readonly="readonly"<?php echo $attr; ?>>
        <?php if (!$disabled) : ?>
            <button type="button"
                    class="uk-button uk-button-primary btn-ui-image-upload-select"><?php echo Text::_("JLIB_FORM_BUTTON_SELECT"); ?></button>
        <?php endif; ?>
    </div>
</joomla-field-media>
